/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.Frame;
import au.com.southsky.jfreesane.FrameType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

final class SaneImage {
    private static final Set<FrameType> singletonFrameTypes = Sets.immutableEnumSet((Enum)FrameType.GRAY, (Enum[])new FrameType[]{FrameType.RGB});
    private static final Set<FrameType> redGreenBlueFrameTypes = Sets.immutableEnumSet((Enum)FrameType.RED, (Enum[])new FrameType[]{FrameType.GREEN, FrameType.BLUE});
    private final List<Frame> frames;
    private final int depthPerPixel;
    private final int width;
    private final int height;
    private final int bytesPerLine;

    private SaneImage(List<Frame> frames, int depthPerPixel, int width, int height, int bytesPerLine) {
        this.frames = Ordering.explicit((Object)FrameType.RED, (Object[])new FrameType[]{FrameType.GREEN, FrameType.BLUE, FrameType.RGB, FrameType.GRAY}).onResultOf((Function)new Function<Frame, FrameType>(){

            public FrameType apply(Frame input) {
                return input.getType();
            }
        }).immutableSortedCopy(frames);
        this.depthPerPixel = depthPerPixel;
        this.width = width;
        this.height = height;
        this.bytesPerLine = bytesPerLine;
    }

    private List<Frame> getFrames() {
        return this.frames;
    }

    private int getDepthPerPixel() {
        return this.depthPerPixel;
    }

    private int getWidth() {
        return this.width;
    }

    private int getHeight() {
        return this.height;
    }

    private int getBytesPerLine() {
        return this.bytesPerLine;
    }

    BufferedImage toBufferedImage() {
        DataBuffer buffer = this.asDataBuffer();
        if (this.getFrames().size() == redGreenBlueFrameTypes.size()) {
            WritableRaster raster = Raster.createBandedRaster(buffer, this.getWidth(), this.getHeight(), this.getBytesPerLine(), new int[]{0, 1, 2}, new int[]{0, 0, 0}, new Point(0, 0));
            ComponentColorModel model = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
            return new BufferedImage(model, raster, false, null);
        }
        if (this.depthPerPixel == 1) {
            if (this.getFrames().get(0).getType() == FrameType.GRAY) {
                return this.decodeSingleBitGrayscaleImage(buffer);
            }
            return this.decodeSingleBitColorImage();
        }
        if (this.getDepthPerPixel() == 8 || this.getDepthPerPixel() == 16) {
            int[] bandOffsets;
            ColorSpace colorSpace;
            if (this.getFrames().get(0).getType() == FrameType.GRAY) {
                colorSpace = ColorSpace.getInstance(1003);
                bandOffsets = new int[]{0};
            } else {
                colorSpace = ColorSpace.getInstance(1000);
                bandOffsets = new int[]{0, 1, 2};
            }
            WritableRaster raster = Raster.createInterleavedRaster(buffer, this.width, this.height, this.bytesPerLine * 8 / this.depthPerPixel, bandOffsets.length, bandOffsets, new Point(0, 0));
            ComponentColorModel model = new ComponentColorModel(colorSpace, false, false, 1, this.getDepthPerPixel() == 8 ? 0 : 1);
            return new BufferedImage(model, raster, false, null);
        }
        throw new IllegalStateException("Unsupported SaneImage type");
    }

    private BufferedImage decodeSingleBitGrayscaleImage(DataBuffer buffer) {
        WritableRaster raster = Raster.createPackedRaster(buffer, this.width, this.height, 1, new Point(0, 0));
        return new BufferedImage(new IndexColorModel(1, 2, new byte[]{-1, 0}, new byte[]{-1, 0}, new byte[]{-1, 0}), raster, false, null);
    }

    private BufferedImage decodeSingleBitColorImage() {
        byte[] data = this.frames.get(0).getData();
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        int componentCount = 3;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int lineStartByte = y * this.bytesPerLine;
                int offsetWithinLine = x / 8 * componentCount;
                int offsetWithinByte = 1 << 8 - x % 8 - 1;
                boolean red = (data[lineStartByte + offsetWithinLine] & offsetWithinByte) != 0;
                boolean green = (data[lineStartByte + offsetWithinLine + 1] & offsetWithinByte) != 0;
                boolean blue = (data[lineStartByte + offsetWithinLine + 2] & offsetWithinByte) != 0;
                int rgb = red ? 0xFF0000 : 0;
                rgb |= green ? 65280 : 0;
                image.setRGB(x, y, rgb |= blue ? 255 : 0);
            }
        }
        return image;
    }

    private DataBuffer asDataBuffer() {
        if (this.depthPerPixel == 1 || this.depthPerPixel == 8) {
            byte[][] buffers = new byte[this.getFrames().size()][];
            for (int i = 0; i < this.getFrames().size(); ++i) {
                buffers[i] = this.getFrames().get(i).getData();
            }
            return new DataBufferByte(buffers, this.getFrames().get(0).getData().length);
        }
        short[][] buffers = new short[this.getFrames().size()][];
        int stride = 2;
        for (int i = 0; i < this.getFrames().size(); ++i) {
            byte[] bank = this.getFrames().get(i).getData();
            buffers[i] = new short[bank.length / stride];
            for (int j = 0; j < buffers[i].length; ++j) {
                buffers[i][j] = (short)((bank[stride * j] & 0xFF) << 8);
                short[] sArray = buffers[i];
                int n = j;
                sArray[n] = (short)(sArray[n] | (short)(bank[stride * j + 1] & 0xFF));
            }
        }
        return new DataBufferUShort(buffers, this.getFrames().get(0).getData().length / stride);
    }

    private static class WriteOnce<T> {
        private T value = null;

        private WriteOnce() {
        }

        public void set(T newValue) {
            if (this.value == null) {
                this.value = newValue;
            } else if (!newValue.equals(this.value)) {
                throw new IllegalArgumentException("Cannot overwrite with a different value");
            }
        }

        public T get() {
            return this.value;
        }
    }

    public static class Builder {
        private final List<Frame> frames = Lists.newArrayList();
        private final Set<FrameType> frameTypes = EnumSet.noneOf(FrameType.class);
        private final WriteOnce<Integer> depthPerPixel = new WriteOnce();
        private final WriteOnce<Integer> width = new WriteOnce();
        private final WriteOnce<Integer> height = new WriteOnce();
        private final WriteOnce<Integer> bytesPerLine = new WriteOnce();

        public void addFrame(Frame frame) {
            Preconditions.checkArgument((!this.frameTypes.contains(frame.getType()) ? 1 : 0) != 0, (Object)"Image already contains a frame of this type");
            Preconditions.checkArgument((this.frameTypes.isEmpty() || !singletonFrameTypes.contains(frame.getType()) ? 1 : 0) != 0, (Object)"The frame type is singleton but this image contains another frame");
            Preconditions.checkArgument((this.frames.isEmpty() || this.frames.get(0).getData().length == frame.getData().length ? 1 : 0) != 0, (Object)"new frame has an inconsistent size");
            this.setPixelDepth(frame.getPixelDepth());
            this.setBytesPerLine(frame.getBytesPerLine());
            this.setWidth(frame.getWidth());
            this.setHeight(frame.getHeight());
            this.frameTypes.add(frame.getType());
            this.frames.add(frame);
        }

        public void setPixelDepth(int newDepth) {
            Preconditions.checkArgument((newDepth > 0 ? 1 : 0) != 0, (Object)"depth must be positive");
            this.depthPerPixel.set(newDepth);
        }

        public void setWidth(int width) {
            this.width.set(width);
        }

        public void setHeight(int height) {
            this.height.set(height);
        }

        public void setBytesPerLine(int bytesPerLine) {
            this.bytesPerLine.set(bytesPerLine);
        }

        public SaneImage build() {
            Preconditions.checkState((!this.frames.isEmpty() ? 1 : 0) != 0, (Object)"no frames");
            Preconditions.checkState((this.depthPerPixel.get() != null ? 1 : 0) != 0, (Object)"setPixelDepth must be called");
            Preconditions.checkState((this.width.get() != null ? 1 : 0) != 0, (Object)"setWidth must be called");
            Preconditions.checkState((this.height.get() != null ? 1 : 0) != 0, (Object)"setHeight must be called");
            Preconditions.checkState((this.bytesPerLine.get() != null ? 1 : 0) != 0, (Object)"setBytesPerLine must be called");
            if (this.frames.size() == 1 && singletonFrameTypes.contains(this.frames.get(0).getType())) {
                return new SaneImage(this.frames, this.depthPerPixel.get(), this.width.get(), this.height.get(), this.bytesPerLine.get());
            }
            if (this.frames.size() == redGreenBlueFrameTypes.size() && redGreenBlueFrameTypes.containsAll(this.frameTypes)) {
                return new SaneImage(this.frames, this.depthPerPixel.get(), this.width.get(), this.height.get(), this.bytesPerLine.get());
            }
            throw new IllegalStateException("Image is not fully constructed. Frame types present: " + this.frameTypes);
        }
    }
}

