/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.OptionCapability;
import au.com.southsky.jfreesane.OptionGroup;
import au.com.southsky.jfreesane.OptionValueConstraintType;
import au.com.southsky.jfreesane.OptionValueType;
import au.com.southsky.jfreesane.RangeConstraint;
import au.com.southsky.jfreesane.SaneDevice;
import au.com.southsky.jfreesane.SaneEnums;
import au.com.southsky.jfreesane.SaneException;
import au.com.southsky.jfreesane.SaneOption;
import au.com.southsky.jfreesane.SaneOptionDescriptor;
import au.com.southsky.jfreesane.SaneParameters;
import au.com.southsky.jfreesane.SaneSession;
import au.com.southsky.jfreesane.SaneStatus;
import au.com.southsky.jfreesane.SaneWord;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class SaneInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger(SaneInputStream.class.getName());
    private final SaneSession saneSession;
    private InputStream wrappedStream;
    private OptionGroup currentGroup;

    SaneInputStream(SaneSession saneSession, InputStream wrappedStream) {
        this.saneSession = saneSession;
        this.wrappedStream = wrappedStream;
    }

    @Override
    public int read() throws IOException {
        return this.wrappedStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.wrappedStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrappedStream.read(b, off, len);
    }

    public List<SaneDevice> readDeviceList() throws IOException, SaneException {
        SaneStatus status = this.readStatus();
        if (!SaneStatus.STATUS_GOOD.equals(status)) {
            throw new SaneException(status);
        }
        int length = this.readWord().integerValue() - 1;
        if (length <= 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < length; ++i) {
            SaneDevice device = this.readSaneDevicePointer();
            if (device == null) {
                throw new IllegalStateException("null pointer encountered when not expected");
            }
            result.add((Object)device);
        }
        this.readWord();
        return result.build();
    }

    private SaneDevice readSaneDevicePointer() throws IOException {
        this.readPointer();
        return this.readSaneDevice();
    }

    private boolean readPointer() throws IOException {
        return this.readWord().integerValue() != 0;
    }

    private SaneDevice readSaneDevice() throws IOException {
        String deviceName = this.readString();
        String deviceVendor = this.readString();
        String deviceModel = this.readString();
        String deviceType = this.readString();
        return new SaneDevice(this.saneSession, deviceName, deviceVendor, deviceModel, deviceType);
    }

    public String readString() throws IOException {
        int length = this.readWord().integerValue();
        if (length == 0) {
            return "";
        }
        byte[] input = new byte[length];
        if (ByteStreams.read((InputStream)this, (byte[])input, (int)0, (int)length) != length) {
            throw new IllegalStateException("truncated input while reading string");
        }
        return new String(input, 0, input.length - 1, Charsets.ISO_8859_1);
    }

    public SaneParameters readSaneParameters() throws IOException {
        int frame = this.readWord().integerValue();
        boolean lastFrame = this.readWord().integerValue() == 1;
        int bytesPerLine = this.readWord().integerValue();
        int pixelsPerLine = this.readWord().integerValue();
        int lines = this.readWord().integerValue();
        int depth = this.readWord().integerValue();
        return new SaneParameters(frame, lastFrame, bytesPerLine, pixelsPerLine, lines, depth);
    }

    public SaneStatus readStatus() throws IOException {
        return SaneStatus.fromWireValue(this.readWord().integerValue());
    }

    public SaneWord readWord() throws IOException {
        return SaneWord.fromStream(this);
    }

    public SaneOptionDescriptor readOptionDescriptor() throws IOException {
        this.readWord();
        String optionName = this.readString();
        String optionTitle = this.readString();
        String optionDescription = this.readString();
        int typeInt = this.readWord().integerValue();
        OptionValueType valueType = SaneEnums.valueOf(OptionValueType.class, typeInt);
        if (valueType == OptionValueType.GROUP) {
            this.currentGroup = new OptionGroup(optionTitle);
        }
        int unitsInt = this.readWord().integerValue();
        SaneOption.OptionUnits units = SaneEnums.valueOf(SaneOption.OptionUnits.class, unitsInt);
        int size = this.readWord().integerValue();
        int capabilityWord = this.readWord().integerValue();
        int constraintTypeInt = this.readWord().integerValue();
        OptionValueConstraintType constraintType = SaneEnums.valueOf(OptionValueConstraintType.class, constraintTypeInt);
        ArrayList stringConstraints = null;
        ArrayList valueConstraints = null;
        RangeConstraint rangeConstraint = null;
        block0 : switch (constraintType) {
            case NO_CONSTRAINT: {
                break;
            }
            case STRING_LIST_CONSTRAINT: {
                stringConstraints = Lists.newArrayList();
                int n = this.readWord().integerValue();
                for (int i = 0; i < n; ++i) {
                    String stringConstraint = this.readString();
                    if (i >= n - 1) continue;
                    stringConstraints.add(stringConstraint);
                }
                break;
            }
            case VALUE_LIST_CONSTRAINT: {
                valueConstraints = Lists.newArrayList();
                int n = this.readWord().integerValue();
                for (int i = 0; i < n; ++i) {
                    SaneWord value = this.readWord();
                    if (i == 0) continue;
                    valueConstraints.add(value);
                }
                break;
            }
            case RANGE_CONSTRAINT: {
                this.readWord();
                SaneWord min = this.readWord();
                SaneWord max = this.readWord();
                SaneWord quantization = this.readWord();
                switch (valueType) {
                    case INT: 
                    case FIXED: {
                        rangeConstraint = new RangeConstraint(min, max, quantization);
                        break block0;
                    }
                }
                logger.log(Level.WARNING, "Ignoring invalid option type/constraint combination: value_type={0},constraint_type={1} for option {2}. Option will be treated by jfreesane as unconstrained", new Object[]{valueType, constraintType, optionName});
                break;
            }
            default: {
                throw new IllegalStateException("Unknown constraint type");
            }
        }
        return new SaneOptionDescriptor(optionName, optionTitle, optionDescription, this.currentGroup, valueType, units, size, SaneEnums.enumSet(OptionCapability.class, capabilityWord), constraintType, rangeConstraint, stringConstraints, valueConstraints);
    }
}

