/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.OptionCapability;
import au.com.southsky.jfreesane.OptionGroup;
import au.com.southsky.jfreesane.OptionValueConstraintType;
import au.com.southsky.jfreesane.OptionValueType;
import au.com.southsky.jfreesane.RangeConstraint;
import au.com.southsky.jfreesane.SaneDevice;
import au.com.southsky.jfreesane.SaneEnum;
import au.com.southsky.jfreesane.SaneEnums;
import au.com.southsky.jfreesane.SaneException;
import au.com.southsky.jfreesane.SaneInputStream;
import au.com.southsky.jfreesane.SaneOptionDescriptor;
import au.com.southsky.jfreesane.SaneOutputStream;
import au.com.southsky.jfreesane.SaneRpcCode;
import au.com.southsky.jfreesane.SaneSession;
import au.com.southsky.jfreesane.SaneWord;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public final class SaneOption {
    private static final Logger logger = Logger.getLogger(SaneOption.class.getName());
    private final SaneDevice device;
    private final int optionNumber;
    private final SaneOptionDescriptor descriptor;

    SaneOption(SaneDevice device, int optionNumber, SaneOptionDescriptor descriptor) {
        this.device = device;
        this.optionNumber = optionNumber;
        this.descriptor = descriptor;
        if (descriptor.getGroup() != null && this.getValueType() != OptionValueType.GROUP) {
            descriptor.getGroup().addOption(this);
        }
    }

    static List<SaneOption> optionsFor(SaneDevice device) throws IOException {
        Preconditions.checkState((boolean)device.isOpen(), (Object)"you must open() the device first");
        ArrayList options = Lists.newArrayList();
        SaneSession session = device.getSession();
        SaneInputStream inputStream = session.getInputStream();
        SaneOutputStream outputStream = session.getOutputStream();
        outputStream.write(SaneRpcCode.SANE_NET_GET_OPTION_DESCRIPTORS);
        outputStream.write(device.getHandle().getHandle());
        int length = inputStream.readWord().integerValue() - 1;
        if (length <= 0) {
            return ImmutableList.of();
        }
        for (int i = 0; i <= length; ++i) {
            SaneOption option = SaneOption.fromStream(inputStream, device, i);
            if (option == null) continue;
            if (option.getValueType() == OptionValueType.GROUP) {
                device.addOptionGroup(option.getGroup());
                continue;
            }
            if (i > 0 && Strings.isNullOrEmpty((String)option.getName())) {
                logger.fine(String.format("ignoring null or empty option with id %d: %s", i, option));
                continue;
            }
            options.add(option);
        }
        return options;
    }

    private static SaneOption fromStream(SaneInputStream inputStream, SaneDevice device, int optionNumber) throws IOException {
        return new SaneOption(device, optionNumber, inputStream.readOptionDescriptor());
    }

    public SaneDevice getDevice() {
        return this.device;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getTitle() {
        return this.descriptor.getTitle();
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    public OptionGroup getGroup() {
        return this.descriptor.getGroup();
    }

    public OptionValueType getType() {
        return this.descriptor.getValueType();
    }

    public OptionUnits getUnits() {
        return this.descriptor.getUnits();
    }

    public int getSize() {
        return this.descriptor.getSize();
    }

    public int getValueCount() {
        switch (this.descriptor.getValueType()) {
            case BOOLEAN: 
            case STRING: {
                return 1;
            }
            case INT: 
            case FIXED: {
                return this.getSize() / 4;
            }
            case BUTTON: 
            case GROUP: {
                throw new IllegalStateException("Option type '" + this.descriptor.getValueType() + "' has no value count");
            }
        }
        throw new IllegalStateException("Option type '" + this.descriptor.getValueType() + "' unknown");
    }

    public boolean isConstrained() {
        return !OptionValueConstraintType.NO_CONSTRAINT.equals(this.descriptor.getConstraintType());
    }

    public OptionValueConstraintType getConstraintType() {
        return this.descriptor.getConstraintType();
    }

    public RangeConstraint getRangeConstraints() {
        return this.descriptor.getRangeConstraints();
    }

    public List<String> getStringConstraints() {
        return this.descriptor.getStringConstraints();
    }

    public List<SaneWord> getWordConstraints() {
        return this.descriptor.getWordConstraints();
    }

    public List<Integer> getIntegerValueListConstraint() {
        return Lists.transform(this.descriptor.getWordConstraints(), SaneWord.TO_INTEGER_FUNCTION);
    }

    public List<Double> getFixedValueListConstraint() {
        return Lists.transform(this.descriptor.getWordConstraints(), SaneWord.TO_FIXED_FUNCTION);
    }

    public String toString() {
        return String.format("Option: %s, %s, value type: %s, units: %s", this.descriptor.getName(), this.descriptor.getTitle(), this.descriptor.getValueType(), this.descriptor.getUnits());
    }

    private OptionValueType getValueType() {
        return this.descriptor.getValueType();
    }

    public boolean getBooleanValue() throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.BOOLEAN ? 1 : 0) != 0, (Object)"option is not a boolean");
        Preconditions.checkState((this.getValueCount() == 1 ? 1 : 0) != 0, (Object)"option is a boolean array, not boolean");
        ControlOptionResult result = this.readOption();
        return SaneWord.fromBytes(result.getValue()).integerValue() != 0;
    }

    public int getIntegerValue() throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.INT ? 1 : 0) != 0, (Object)"option is not an integer");
        Preconditions.checkState((this.getValueCount() == 1 ? 1 : 0) != 0, (Object)"option is an integer array, not integer");
        ControlOptionResult result = this.readOption();
        Preconditions.checkState((result.getType() == OptionValueType.INT ? 1 : 0) != 0);
        Preconditions.checkState((result.getValueSize() == 4 ? 1 : 0) != 0, (Object)("unexpected value size " + result.getValueSize() + ", expecting " + 4));
        return SaneWord.fromBytes(result.getValue()).integerValue();
    }

    public List<Integer> getIntegerArrayValue() throws IOException, SaneException {
        ControlOptionResult result = this.readOption();
        Preconditions.checkState((result.getType() == OptionValueType.INT ? 1 : 0) != 0);
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < result.getValueSize(); i += 4) {
            values.add(SaneWord.fromBytes(result.getValue(), i).integerValue());
        }
        return values;
    }

    public String getStringValue() throws IOException, SaneException {
        return this.getStringValue(Charsets.ISO_8859_1);
    }

    public String getStringValue(Charset encoding) throws IOException, SaneException {
        int length;
        Preconditions.checkState((this.getValueType() == OptionValueType.STRING ? 1 : 0) != 0, (Object)"option is not a string");
        ControlOptionResult result = this.readOption();
        byte[] value = result.getValue();
        for (length = 0; length < value.length && value[length] != 0; ++length) {
        }
        return new String(result.getValue(), 0, length, encoding);
    }

    public double getFixedValue() throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.FIXED ? 1 : 0) != 0, (Object)"option is not of fixed precision type");
        ControlOptionResult result = this.readOption();
        return SaneWord.fromBytes(result.getValue()).fixedPrecisionValue();
    }

    public List<Double> getFixedArrayValue() throws IOException, SaneException {
        ControlOptionResult result = this.readOption();
        Preconditions.checkState((result.getType() == OptionValueType.FIXED ? 1 : 0) != 0);
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < result.getValueSize(); i += 4) {
            values.add(SaneWord.fromBytes(result.getValue(), i).fixedPrecisionValue());
        }
        return values;
    }

    private ControlOptionResult readOption() throws IOException, SaneException {
        int elementCount;
        Preconditions.checkState((boolean)this.isReadable(), (Object)"option is not readable");
        Preconditions.checkState((boolean)this.isActive(), (Object)"option is not active");
        SaneOutputStream out = this.device.getSession().getOutputStream();
        out.write(SaneRpcCode.SANE_NET_CONTROL_OPTION);
        out.write(this.device.getHandle().getHandle());
        out.write(SaneWord.forInt(this.optionNumber));
        out.write(OptionAction.GET_VALUE);
        out.write(this.getValueType());
        out.write(SaneWord.forInt(this.getSize()));
        switch (this.getValueType()) {
            case BOOLEAN: 
            case INT: 
            case FIXED: {
                elementCount = this.getSize() / 4;
                break;
            }
            case STRING: {
                elementCount = this.getSize();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type " + this.getValueType());
            }
        }
        out.write(SaneWord.forInt(elementCount));
        for (int i = 0; i < this.getSize(); ++i) {
            out.write(0);
        }
        ControlOptionResult result = ControlOptionResult.fromSession(this.device.getSession());
        return result;
    }

    public boolean setBooleanValue(boolean value) throws IOException, SaneException {
        ControlOptionResult result = this.writeOption(SaneWord.forInt(value ? 1 : 0));
        Preconditions.checkState((result.getType() == OptionValueType.BOOLEAN ? 1 : 0) != 0);
        return SaneWord.fromBytes(result.getValue()).integerValue() != 0;
    }

    public void setButtonValue() throws IOException, SaneException {
        this.writeButtonOption();
    }

    public double setFixedValue(double value) throws IOException, SaneException {
        Preconditions.checkArgument((value >= -32768.0 && value <= 32767.9999 ? 1 : 0) != 0, (Object)("value " + value + " is out of range"));
        SaneWord wordValue = SaneWord.forFixedPrecision(value);
        ControlOptionResult result = this.writeOption(wordValue);
        Preconditions.checkState((result.getType() == OptionValueType.FIXED ? 1 : 0) != 0, (Object)("setFixedValue is not appropriate for option of type " + result.getType()));
        return SaneWord.fromBytes(result.getValue()).fixedPrecisionValue();
    }

    public List<Double> setFixedValue(List<Double> value) throws IOException, SaneException {
        List wordValues = Lists.transform(value, (Function)new Function<Double, SaneWord>(){

            public SaneWord apply(Double input) {
                Preconditions.checkArgument((input >= -32768.0 && input <= 32767.9999 ? 1 : 0) != 0, (Object)("value " + input + " is out of range"));
                return SaneWord.forFixedPrecision(input);
            }
        });
        ControlOptionResult result = this.writeWordListOption(wordValues);
        ArrayList newValues = Lists.newArrayListWithCapacity((int)(result.getValueSize() / 4));
        for (int i = 0; i < result.getValueSize(); i += 4) {
            newValues.add(SaneWord.fromBytes(result.getValue(), i).fixedPrecisionValue());
        }
        return newValues;
    }

    public String setStringValue(String newValue) throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.STRING ? 1 : 0) != 0);
        Preconditions.checkState((this.getValueCount() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isWriteable());
        Preconditions.checkState((newValue.length() < this.getSize() ? 1 : 0) != 0, (Object)("string value '" + newValue + "' (length=" + newValue.length() + ") exceeds maximum size of " + (this.getSize() - 1) + " byte(s) for option " + this.getName()));
        ControlOptionResult result = this.writeOption(newValue);
        Preconditions.checkState((result.getType() == OptionValueType.STRING ? 1 : 0) != 0);
        String optionValueFromServer = new String(result.getValue(), 0, result.getValueSize() - 1, Charsets.ISO_8859_1);
        Preconditions.checkState((boolean)(result.getInfo().contains(OptionWriteInfo.INEXACT) ^ newValue.equals(optionValueFromServer)), (Object)"new option value does not match when it should");
        return optionValueFromServer;
    }

    public int setIntegerValue(int newValue) throws IOException, SaneException {
        Preconditions.checkState((this.getValueCount() == 1 ? 1 : 0) != 0, (Object)"option is an array");
        Preconditions.checkState((boolean)this.isWriteable());
        ControlOptionResult result = this.writeOption((List<Integer>)ImmutableList.of((Object)newValue));
        Preconditions.checkState((result.getType() == OptionValueType.INT ? 1 : 0) != 0);
        Preconditions.checkState((result.getValueSize() == 4 ? 1 : 0) != 0);
        return SaneWord.fromBytes(result.getValue()).integerValue();
    }

    public List<Integer> setIntegerValue(List<Integer> newValue) throws IOException, SaneException {
        ControlOptionResult result = this.writeOption(newValue);
        ArrayList newValues = Lists.newArrayListWithCapacity((int)(result.getValueSize() / 4));
        for (int i = 0; i < result.getValueSize(); i += 4) {
            newValues.add(SaneWord.fromBytes(result.getValue(), i).integerValue());
        }
        return newValues;
    }

    private ControlOptionResult writeWordListOption(List<SaneWord> value) throws IOException, SaneException {
        Preconditions.checkState((boolean)this.isWriteable(), (Object)"option is not writeable");
        Preconditions.checkState((boolean)this.isActive(), (Object)"option is not active");
        SaneOutputStream out = this.device.getSession().getOutputStream();
        out.write(SaneRpcCode.SANE_NET_CONTROL_OPTION);
        out.write(this.device.getHandle().getHandle());
        out.write(SaneWord.forInt(this.optionNumber));
        out.write(SaneWord.forInt(OptionAction.SET_VALUE.getWireValue()));
        out.write(this.getValueType());
        out.write(SaneWord.forInt(value.size() * 4));
        out.write(SaneWord.forInt(value.size()));
        for (SaneWord element : value) {
            out.write(element);
        }
        ControlOptionResult result = this.handleWriteResponse();
        if (result.getInfo().contains(OptionWriteInfo.RELOAD_OPTIONS) || result.getInfo().contains(OptionWriteInfo.RELOAD_PARAMETERS)) {
            this.device.invalidateOptions();
            this.device.listOptions();
        }
        return result;
    }

    private ControlOptionResult writeOption(String value) throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.STRING ? 1 : 0) != 0);
        SaneOutputStream out = this.device.getSession().getOutputStream();
        out.write(SaneRpcCode.SANE_NET_CONTROL_OPTION);
        out.write(SaneWord.forInt(this.device.getHandle().getHandle().integerValue()));
        out.write(SaneWord.forInt(this.optionNumber));
        out.write(SaneWord.forInt(OptionAction.SET_VALUE.getWireValue()));
        out.write(this.getValueType());
        out.write(SaneWord.forInt(value.length() + 1));
        out.write(value);
        return this.handleWriteResponse();
    }

    private ControlOptionResult writeOption(SaneWord word) throws IOException, SaneException {
        return this.writeWordListOption((List<SaneWord>)ImmutableList.of((Object)word));
    }

    private ControlOptionResult writeOption(List<Integer> value) throws IOException, SaneException {
        Preconditions.checkState((boolean)this.isActive(), (String)"option %s is not active", (Object[])new Object[]{this.getName()});
        Preconditions.checkState((boolean)this.isWriteable(), (String)"option %s is not writeable", (Object[])new Object[]{this.getName()});
        Preconditions.checkState((this.getValueType() == OptionValueType.INT ? 1 : 0) != 0, (String)"option %s is %s-typed, you must use the corresponding methods to set the value", (Object[])new Object[]{this.getName(), this.getValueType()});
        SaneOutputStream out = this.device.getSession().getOutputStream();
        out.write(SaneRpcCode.SANE_NET_CONTROL_OPTION);
        out.write(this.device.getHandle().getHandle());
        out.write(SaneWord.forInt(this.optionNumber));
        out.write(OptionAction.SET_VALUE);
        out.write(this.getValueType());
        out.write(SaneWord.forInt(this.getSize()));
        out.write(SaneWord.forInt(value.size()));
        for (Integer element : value) {
            out.write(SaneWord.forInt(element));
        }
        return this.handleWriteResponse();
    }

    private ControlOptionResult writeButtonOption() throws IOException, SaneException {
        Preconditions.checkState((this.getValueType() == OptionValueType.BUTTON ? 1 : 0) != 0);
        SaneOutputStream out = this.device.getSession().getOutputStream();
        out.write(SaneRpcCode.SANE_NET_CONTROL_OPTION);
        out.write(this.device.getHandle().getHandle());
        out.write(SaneWord.forInt(this.optionNumber));
        out.write(OptionAction.SET_VALUE);
        out.write(this.getValueType());
        out.write(SaneWord.forInt(0));
        out.write(SaneWord.forInt(0));
        return this.handleWriteResponse();
    }

    private ControlOptionResult handleWriteResponse() throws IOException, SaneException {
        ControlOptionResult result = ControlOptionResult.fromSession(this.device.getSession());
        if (result.getInfo().contains(OptionWriteInfo.RELOAD_OPTIONS)) {
            this.device.invalidateOptions();
        }
        return result;
    }

    public boolean isActive() {
        return !this.descriptor.getOptionCapabilities().contains(OptionCapability.INACTIVE);
    }

    public boolean isReadable() {
        return this.descriptor.getOptionCapabilities().contains(OptionCapability.SOFT_DETECT);
    }

    public boolean isWriteable() {
        return this.descriptor.getOptionCapabilities().contains(OptionCapability.SOFT_SELECT);
    }

    private static final class ControlOptionResult {
        private final int status;
        private final Set<OptionWriteInfo> info;
        private final OptionValueType type;
        private final int valueSize;
        private final byte[] value;
        private final String resource;

        private ControlOptionResult(int status, int info, OptionValueType type, int valueSize, byte[] value, String resource) {
            this.status = status;
            this.info = SaneEnums.enumSet(OptionWriteInfo.class, info);
            this.type = type;
            this.valueSize = valueSize;
            this.value = value;
            this.resource = resource;
        }

        private static ControlOptionResult fromSession(SaneSession session) throws IOException, SaneException {
            SaneInputStream stream = session.getInputStream();
            SaneWord status = stream.readWord();
            if (status.integerValue() != 0) {
                throw SaneException.fromStatusWord(status);
            }
            int info = stream.readWord().integerValue();
            OptionValueType type = SaneEnums.valueOf(OptionValueType.class, stream.readWord().integerValue());
            int valueSize = stream.readWord().integerValue();
            int pointer = stream.readWord().integerValue();
            byte[] value = null;
            if (pointer != 0 && ByteStreams.read((InputStream)stream, (byte[])(value = new byte[valueSize]), (int)0, (int)valueSize) != valueSize) {
                throw new IOException("truncated read while getting value");
            }
            String resource = stream.readString();
            if (!resource.isEmpty()) {
                session.authorize(resource);
                status = stream.readWord();
                if (status.integerValue() != 0) {
                    throw SaneException.fromStatusWord(status);
                }
                info = stream.readWord().integerValue();
                type = SaneEnums.valueOf(OptionValueType.class, stream.readWord().integerValue());
                valueSize = stream.readWord().integerValue();
                pointer = stream.readWord().integerValue();
                value = null;
                if (pointer != 0 && stream.read(value = new byte[valueSize]) != valueSize) {
                    throw new IOException("truncated read while getting value");
                }
            }
            return new ControlOptionResult(status.integerValue(), info, type, valueSize, value, resource);
        }

        public int getStatus() {
            return this.status;
        }

        public Set<OptionWriteInfo> getInfo() {
            return Sets.immutableEnumSet(this.info);
        }

        public OptionValueType getType() {
            return this.type;
        }

        public int getValueSize() {
            return this.valueSize;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getResource() {
            return this.resource;
        }
    }

    public static enum OptionWriteInfo implements SaneEnum
    {
        INEXACT(1),
        RELOAD_OPTIONS(2),
        RELOAD_PARAMETERS(4);

        private final int wireValue;

        private OptionWriteInfo(int wireValue) {
            this.wireValue = wireValue;
        }

        @Override
        public int getWireValue() {
            return this.wireValue;
        }
    }

    public static enum OptionUnits implements SaneEnum
    {
        UNIT_NONE(0),
        UNIT_PIXEL(1),
        UNIT_BIT(2),
        UNIT_MM(3),
        UNIT_DPI(4),
        UNIT_PERCENT(5),
        UNIT_MICROSECOND(6);

        private final int wireValue;

        private OptionUnits(int wireValue) {
            this.wireValue = wireValue;
        }

        @Override
        public int getWireValue() {
            return this.wireValue;
        }
    }

    private static enum OptionAction implements SaneEnum
    {
        GET_VALUE(0),
        SET_VALUE(1),
        SET_AUTO(2);

        private int actionNo;

        private OptionAction(int actionNo) {
            this.actionNo = actionNo;
        }

        @Override
        public int getWireValue() {
            return this.actionNo;
        }
    }
}

