/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.SaneEnum;
import au.com.southsky.jfreesane.SanePasswordEncoder;
import au.com.southsky.jfreesane.SaneWord;
import java.io.IOException;
import java.io.OutputStream;

class SaneOutputStream
extends OutputStream {
    private final OutputStream wrappedStream;

    SaneOutputStream(OutputStream wrappedStream) {
        this.wrappedStream = wrappedStream;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrappedStream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.wrappedStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrappedStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrappedStream.write(b, off, len);
    }

    public void write(String string) throws IOException {
        this.write(string.toCharArray());
    }

    public void write(char[] charArray) throws IOException {
        if (charArray.length > 0) {
            byte[] encoded = SanePasswordEncoder.encodedLatin1(charArray);
            this.write(SaneWord.forInt(encoded.length + 1));
            this.write(encoded);
        }
        this.write(0);
    }

    public void write(SaneWord word) throws IOException {
        this.write(word.getValue());
    }

    public void write(SaneEnum someEnum) throws IOException {
        this.write(SaneWord.forInt(someEnum.getWireValue()));
    }
}

