/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.SaneClientAuthentication;
import com.google.common.base.Strings;

public abstract class SanePasswordProvider {
    public abstract String getUsername(String var1);

    public abstract String getPassword(String var1);

    public abstract boolean canAuthenticate(String var1);

    public static SanePasswordProvider forUsernameAndPassword(final String username, final String password) {
        return new SanePasswordProvider(){

            @Override
            public String getUsername(String resource) {
                return username;
            }

            @Override
            public String getPassword(String resource) {
                return password;
            }

            @Override
            public boolean canAuthenticate(String resource) {
                return true;
            }
        };
    }

    public static SanePasswordProvider usingDotSanePassFile() {
        return SanePasswordProvider.usingSanePassFile(null);
    }

    public static SanePasswordProvider usingSanePassFile(String passwordFile) {
        return Strings.isNullOrEmpty((String)passwordFile) ? new SaneClientAuthentication() : new SaneClientAuthentication(passwordFile);
    }
}

