/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.FrameReader;
import au.com.southsky.jfreesane.SaneDevice;
import au.com.southsky.jfreesane.SaneDeviceHandle;
import au.com.southsky.jfreesane.SaneException;
import au.com.southsky.jfreesane.SaneImage;
import au.com.southsky.jfreesane.SaneInputStream;
import au.com.southsky.jfreesane.SaneOutputStream;
import au.com.southsky.jfreesane.SaneParameters;
import au.com.southsky.jfreesane.SanePasswordEncoder;
import au.com.southsky.jfreesane.SanePasswordProvider;
import au.com.southsky.jfreesane.SaneRpcCode;
import au.com.southsky.jfreesane.SaneStatus;
import au.com.southsky.jfreesane.SaneWord;
import au.com.southsky.jfreesane.ScanListener;
import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SaneSession
implements Closeable {
    private static final int READ_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_PORT = 6566;
    private final Socket socket;
    private final SaneOutputStream outputStream;
    private final SaneInputStream inputStream;
    private SanePasswordProvider passwordProvider = SanePasswordProvider.usingDotSanePassFile();

    private SaneSession(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new SaneOutputStream(socket.getOutputStream());
        this.inputStream = new SaneInputStream(this, socket.getInputStream());
    }

    public SanePasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public void setPasswordProvider(SanePasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public static SaneSession withRemoteSane(InetAddress saneAddress) throws IOException {
        return SaneSession.withRemoteSane(saneAddress, 6566);
    }

    public static SaneSession withRemoteSane(InetAddress saneAddress, long timeout, TimeUnit timeUnit) throws IOException {
        return SaneSession.withRemoteSane(saneAddress, 6566, timeout, timeUnit);
    }

    public static SaneSession withRemoteSane(InetAddress saneAddress, int port) throws IOException {
        return SaneSession.withRemoteSane(saneAddress, port, 0L, TimeUnit.MILLISECONDS);
    }

    public static SaneSession withRemoteSane(InetAddress saneAddress, int port, long timeout, TimeUnit timeUnit) throws IOException {
        long millis = timeUnit.toMillis(timeout);
        Preconditions.checkArgument((millis >= 0L && millis <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Timeout must be between 0 and Integer.MAX_VALUE milliseconds");
        if (timeout > 0L && millis == 0L) {
            Logger.getLogger(SaneSession.class.getName()).log(Level.WARNING, "Specified timeout of {0} {1} rounds to 0ms and was clamped to 1ms", new Object[]{timeout, timeUnit});
        }
        Socket socket = new Socket();
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(saneAddress, port), (int)millis);
        SaneSession session = new SaneSession(socket);
        session.initSane();
        return session;
    }

    public SaneDevice getDevice(String name) throws IOException {
        return new SaneDevice(this, name, "", "", "");
    }

    public List<SaneDevice> listDevices() throws IOException, SaneException {
        this.outputStream.write(SaneRpcCode.SANE_NET_GET_DEVICES);
        return this.inputStream.readDeviceList();
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.write(SaneRpcCode.SANE_NET_EXIT);
            this.outputStream.close();
        }
        finally {
            this.socket.close();
        }
    }

    SaneDeviceHandle openDevice(SaneDevice device) throws IOException, SaneException {
        this.outputStream.write(SaneRpcCode.SANE_NET_OPEN);
        this.outputStream.write(device.getName());
        SaneWord status = this.inputStream.readWord();
        if (status.integerValue() != 0) {
            throw new SaneException(SaneStatus.fromWireValue(status.integerValue()));
        }
        SaneWord handle = this.inputStream.readWord();
        String resource = this.inputStream.readString();
        if (!resource.isEmpty()) {
            this.authorize(resource);
            status = this.inputStream.readWord();
            if (status.integerValue() != 0) {
                throw new SaneException(SaneStatus.fromWireValue(status.integerValue()));
            }
            handle = this.inputStream.readWord();
            resource = this.inputStream.readString();
        }
        return new SaneDeviceHandle(status, handle, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage acquireImage(SaneDevice device, ScanListener listener) throws IOException, SaneException {
        SaneImage.Builder builder = new SaneImage.Builder();
        SaneParameters parameters = null;
        listener.scanningStarted(device);
        int currentFrame = 0;
        do {
            SaneDeviceHandle handle = device.getHandle();
            this.outputStream.write(SaneRpcCode.SANE_NET_START);
            this.outputStream.write(handle.getHandle());
            SaneWord startStatus = this.inputStream.readWord();
            int port = this.inputStream.readWord().integerValue();
            SaneWord byteOrder = this.inputStream.readWord();
            String resource = this.inputStream.readString();
            if (startStatus.integerValue() != 0) {
                throw SaneException.fromStatusWord(startStatus);
            }
            if (!resource.isEmpty()) {
                this.authorize(resource);
                int status = this.inputStream.readWord().integerValue();
                if (status != 0) {
                    throw new SaneException(SaneStatus.fromWireValue(status));
                }
                port = this.inputStream.readWord().integerValue();
                byteOrder = this.inputStream.readWord();
                resource = this.inputStream.readString();
            }
            this.outputStream.write(SaneRpcCode.SANE_NET_GET_PARAMETERS);
            this.outputStream.write(handle.getHandle());
            try (Socket imageSocket = null;){
                imageSocket = new Socket(this.socket.getInetAddress(), port);
                int status = this.inputStream.readWord().integerValue();
                if (status != 0) {
                    throw new IOException("Unexpected status (" + status + ") in get_parameters");
                }
                parameters = this.inputStream.readSaneParameters();
                listener.frameAcquisitionStarted(device, parameters, currentFrame, this.getLikelyTotalFrameCount(parameters));
                FrameReader frameStream = new FrameReader(device, parameters, new BufferedInputStream(imageSocket.getInputStream(), 0x100000), 17185 == byteOrder.integerValue(), listener);
                builder.addFrame(frameStream.readFrame());
            }
            ++currentFrame;
        } while (!parameters.isLastFrame());
        listener.scanningFinished(device);
        SaneImage image = builder.build();
        return image.toBufferedImage();
    }

    private int getLikelyTotalFrameCount(SaneParameters parameters) {
        switch (parameters.getFrameType()) {
            case RED: 
            case GREEN: 
            case BLUE: {
                return 3;
            }
        }
        return 1;
    }

    void closeDevice(SaneDeviceHandle handle) throws IOException {
        this.outputStream.write(SaneRpcCode.SANE_NET_CLOSE);
        this.outputStream.write(handle.getHandle());
        this.inputStream.readWord();
    }

    void cancelDevice(SaneDeviceHandle handle) throws IOException {
        this.outputStream.write(SaneRpcCode.SANE_NET_CANCEL);
        this.outputStream.write(handle.getHandle());
        this.inputStream.readWord();
    }

    private void initSane() throws IOException {
        this.outputStream.write(SaneRpcCode.SANE_NET_INIT);
        this.outputStream.write(SaneWord.forSaneVersion(1, 0, 3));
        this.outputStream.write(System.getProperty("user.name"));
        this.inputStream.readWord();
        this.inputStream.readWord();
    }

    void authorize(String resource) throws IOException {
        if (this.passwordProvider == null) {
            throw new IOException("Authorization failed - no password provider present (you must call setPasswordProvider)");
        }
        this.outputStream.write(SaneRpcCode.SANE_NET_AUTHORIZE);
        this.outputStream.write(resource);
        if (!this.passwordProvider.canAuthenticate(resource)) {
            throw new IOException("Authorization failed - the password provider is unable to provide a password for the resource [" + resource + "]");
        }
        this.outputStream.write(this.passwordProvider.getUsername(resource));
        this.writePassword(resource, this.passwordProvider.getPassword(resource));
        this.inputStream.readWord();
    }

    private void writePassword(String resource, String password) throws IOException {
        String[] resourceParts = resource.split("\\$MD5\\$");
        if (resourceParts.length == 1) {
            this.outputStream.write(password);
        } else {
            this.outputStream.write("$MD5$" + SanePasswordEncoder.derivePassword(resourceParts[1], password));
        }
    }

    SaneOutputStream getOutputStream() {
        return this.outputStream;
    }

    SaneInputStream getInputStream() {
        return this.inputStream;
    }
}

