/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class SaneWord {
    public static final int SIZE_IN_BYTES = 4;
    private static final int PRECISION = 65536;
    public static final Function<SaneWord, Integer> TO_INTEGER_FUNCTION = new Function<SaneWord, Integer>(){

        public Integer apply(SaneWord word) {
            return word.integerValue();
        }
    };
    public static final Function<SaneWord, Double> TO_FIXED_FUNCTION = new Function<SaneWord, Double>(){

        public Double apply(SaneWord word) {
            return word.fixedPrecisionValue();
        }
    };
    private final byte[] value;

    private SaneWord(byte[] value) {
        this.value = value;
    }

    public static SaneWord fromStream(InputStream input) throws IOException {
        byte[] newValue = new byte[4];
        if (ByteStreams.read((InputStream)input, (byte[])newValue, (int)0, (int)newValue.length) != newValue.length) {
            throw new IOException("input stream was truncated while reading a word");
        }
        return new SaneWord(newValue);
    }

    public static SaneWord forInt(int value) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(4);
        DataOutputStream stream = new DataOutputStream(byteStream);
        try {
            stream.writeInt(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return new SaneWord(byteStream.toByteArray());
    }

    public static SaneWord forSaneVersion(int major, int minor, int build) {
        int result = (major & 0xFF) << 24;
        result |= (minor & 0xFF) << 16;
        return SaneWord.forInt(result |= (build & 0xFFFF) << 0);
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int integerValue() {
        try {
            return new DataInputStream(new ByteArrayInputStream(this.value)).readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public double fixedPrecisionValue() {
        return (double)this.integerValue() / 65536.0;
    }

    public static SaneWord fromBytes(byte[] byteValue) {
        return SaneWord.fromBytes(byteValue, 0);
    }

    public static SaneWord fromBytes(byte[] byteValue, int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be positive or zero");
        Preconditions.checkArgument((offset + 4 <= byteValue.length ? 1 : 0) != 0);
        return new SaneWord(Arrays.copyOfRange(byteValue, offset, offset + 4));
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    public static SaneWord forFixedPrecision(double value) {
        return SaneWord.forInt((int)(value * 65536.0));
    }
}

