/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import java.util.EventObject;
import javax.tv.service.selection.ServiceContext;

public class AppSignalEvent
extends EventObject {
    public static final byte AUTOSTART = 1;
    public static final byte STORE = 2;
    public static final byte START = 3;
    public static final byte PRESENT = 4;
    public static final byte PREFETCH = 5;
    public static final byte PAUSE = 6;
    public static final byte DESTROY = 7;
    public static final byte KILL = 8;
    private byte controlCode = 0;
    private String className = null;
    private String appID = null;
    private String baseDir = null;
    private String[] args = null;
    private ServiceContext context = null;

    public AppSignalEvent(Object source, byte controlCode, String baseDir, String className, String id, ServiceContext context, String[] args) {
        super(source);
        if (controlCode < 1 || controlCode > 8) {
            throw new IllegalArgumentException("wrong value for control");
        }
        this.controlCode = controlCode;
        this.baseDir = baseDir;
        this.className = className;
        this.appID = id;
        this.args = args;
        this.context = context;
    }

    public byte getControlCode() {
        return this.controlCode;
    }

    public String getBaseDirectory() {
        return this.baseDir;
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getApplicationIdentifier() {
        return this.appID;
    }

    public ServiceContext getServiceContext() {
        return this.context;
    }

    public String toString() {
        return this.appID + " " + this.baseDir + " " + this.className + " " + this.controlCode;
    }
}

