/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.media.amovie.VisualComponent;
import com.sun.tv.XletContainer;
import com.sun.tv.receiver.Settings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class DisplayManager {
    private static DisplayManager displayManager = null;
    private Container toplevel_container = new Container(){

        public Component add(Component c) {
            System.out.print("ROOTFRAME:  ");
            if (c instanceof VisualComponent) {
                System.out.println("VIDEO -1:" + c);
                super.add(c, -1);
            } else {
                System.out.println("OTHER 0:" + c);
                super.add(c, 0);
            }
            return c;
        }
    };
    private Container rootlevel_container = null;

    public DisplayManager() {
        this.toplevel_container.setLayout(new BorderLayout());
        this.toplevel_container.setSize(640, 480);
        this.toplevel_container.validate();
        this.toplevel_container.addKeyListener(new MyKeyListener());
        try {
            this.rootlevel_container = (Container)Class.forName(Settings.RootContainerClassName).newInstance();
            this.rootlevel_container.addKeyListener(new MyKeyListener());
            this.rootlevel_container.setSize(640, 480);
            this.rootlevel_container.add(this.toplevel_container);
            this.rootlevel_container.validate();
            this.rootlevel_container.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DisplayManager createInstance() {
        if (displayManager != null) {
            return displayManager;
        }
        displayManager = new DisplayManager();
        return displayManager;
    }

    public Container getRootFrame() {
        return this.toplevel_container;
    }

    public XletContainer createXletContainer() {
        XletContainer container = new XletContainer();
        container.setVisible(false);
        container.setBackground(Color.white);
        container.setForeground(Color.black);
        container.setEnabled(true);
        this.toplevel_container.add(container);
        return container;
    }

    public void destroyXletContainer(XletContainer container) {
        if (container != null) {
            this.toplevel_container.remove(container);
        }
    }

    public void showXletContainer(XletContainer container) {
        this.toplevel_container.removeAll();
        this.toplevel_container.add(container);
    }

    public void hideXletContainer(XletContainer container) {
        this.toplevel_container.removeAll();
    }

    public void signalUserNonAutoStartXlet() {
        System.out.println("DisplayManager.signalUserNonAutoStartXlet() not implemented!!!!");
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            this.passEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            this.passEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.passEvent(e);
        }

        void passEvent(KeyEvent e) {
            Object o = e.getSource();
            if (o instanceof Container) {
                Container ctn = (Container)o;
                Component[] c = ctn.getComponents();
                for (int i = 0; i < c.length; ++i) {
                    if (!(c[i] instanceof Container)) continue;
                    c[i].dispatchEvent(new KeyEvent(c[i], e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar()));
                }
            }
        }
    }
}

