/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.tv.DisplayManager;
import com.sun.tv.XletContainer;
import com.sun.tv.XletManager;
import com.sun.tv.XletState;
import javax.tv.service.selection.ServiceContext;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;

public class XletContextImpl
implements XletContext {
    public static final String CONTAINER = "javax.tv.xlet.container";
    public static final String SERVICE_CONTEXT = "javax.tv.xlet.service_context";
    public static final String ROOT_CONTAINER = "javax.tv.xlet.root_container";
    private XletManager xletManager = null;
    private XletContainer xletContainer = null;
    private Xlet xlet = null;
    private String[] args = null;
    private ServiceContext context = null;

    public XletContextImpl(XletManager xletMgr, Xlet xlet, ServiceContext context, String[] args) {
        this.xletManager = xletMgr;
        this.xlet = xlet;
        this.args = args;
        this.context = context;
    }

    private DisplayManager getDisplayMgr() {
        return DisplayManager.createInstance();
    }

    public Object getXletProperty(String prop) {
        if (prop == null) {
            throw new NullPointerException("String is null");
        }
        if ("javax.tv.xlet.args".equals(prop)) {
            return this.args;
        }
        if (CONTAINER.equals(prop)) {
            XletState state;
            if (this.xlet != null && this.xletManager != null && (state = this.xletManager.getXletState(this.xlet)).getState() == 3) {
                return null;
            }
            if (this.xletContainer == null) {
                this.xletContainer = this.getDisplayMgr().createXletContainer();
            }
            return this.xletContainer;
        }
        if (ROOT_CONTAINER.equals(prop)) {
            return this.getDisplayMgr().getRootFrame();
        }
        if (SERVICE_CONTEXT.equals(prop)) {
            XletState state;
            if (this.xlet != null && this.xletManager != null && (state = this.xletManager.getXletState(this.xlet)).getState() == 3) {
                return null;
            }
            return this.context;
        }
        return null;
    }

    public void notifyPaused() {
        this.xletManager.changeXletState(this.xlet, 1);
    }

    public void resumeRequest() {
        this.xletManager.changeXletState(this.xlet, 2);
    }

    public void notifyDestroyed() {
        this.xletManager.changeXletState(this.xlet, 3);
        this.getDisplayMgr().destroyXletContainer(this.xletContainer);
        try {
            if (this.context != null) {
                this.context.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context = null;
    }
}

