/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.controls;

import com.sun.tv.media.controls.AtomicControl;
import com.sun.tv.media.controls.ControlChangeEvent;
import com.sun.tv.media.controls.ControlChangeListener;
import java.awt.Component;
import java.util.Vector;
import javax.media.Control;

public class AtomicControlAdapter
implements AtomicControl {
    protected Component component = null;
    private Vector listeners = null;
    protected boolean isdefault = false;
    protected Control parent = null;
    protected boolean enabled = true;

    public AtomicControlAdapter(Component c, boolean def, Control parent) {
        this.component = c;
        this.isdefault = def;
        this.parent = parent;
    }

    public boolean isDefault() {
        return this.isdefault;
    }

    public void setVisible(boolean visible) {
    }

    public boolean getVisible() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.component != null) {
            this.component.setEnabled(enabled);
        }
        this.informListeners();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setParent(Control p) {
        this.parent = p;
    }

    public Control getParent() {
        return this.parent;
    }

    public void addControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (ccl != null) {
            this.listeners.addElement(ccl);
        }
    }

    public void removeControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners != null && ccl != null) {
            this.listeners.removeElement(ccl);
        }
    }

    public void informListeners() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ControlChangeListener ccl = (ControlChangeListener)this.listeners.elementAt(i);
                ccl.controlChanged(new ControlChangeEvent(this));
            }
        }
    }

    public String getTip() {
        return null;
    }

    public void setTip(String tip) {
    }

    public Component getControlComponent() {
        return this.component;
    }

    public boolean isReadOnly() {
        return false;
    }
}

