/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.protocol.component;

import com.sun.tv.LocatorImpl;
import com.sun.tv.media.protocol.component.PushSourceStream2Impl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;

public class DataSource
extends PushDataSource {
    protected boolean connected = false;
    protected boolean started = false;
    protected URL url = null;
    protected URLConnection urlConnection = null;
    protected ContentDescriptor contentType;
    protected PushSourceStream2Impl[] sources = null;

    public PushSourceStream[] getStreams() {
        if (this.sources != null && this.sources[0] != null) {
            return this.sources;
        }
        return new PushSourceStream2Impl[0];
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("Unconnected DataSource");
        }
        return this.contentType.getContentType();
    }

    public void connect() throws IOException {
        String urlPath = LocatorImpl.getMediaFile(this.getLocator().toExternalForm());
        try {
            this.url = new URL(urlPath);
        }
        catch (MalformedURLException mue) {
            throw new IOException("Invalid locator");
        }
        this.urlConnection = this.url.openConnection();
        this.urlConnection.connect();
        this.connected = true;
        String mimeType = this.urlConnection.getContentType();
        if (mimeType == null) {
            mimeType = "UnknownContent";
        }
        this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType));
        this.sources = new PushSourceStream2Impl[1];
        this.sources[0] = new PushSourceStream2Impl(this.urlConnection, this.contentType);
    }

    public void disconnect() {
        if (this.connected) {
            this.sources[0].close();
            this.connected = false;
        }
    }

    public void start() throws IOException {
        this.started = true;
    }

    public void stop() throws IOException {
        this.started = false;
    }

    public Object[] getControls() {
        Object[] controls = new Object[]{this.sources[0], this};
        return controls;
    }

    public Object getControl(String controlType) {
        if (controlType == null || this.sources == null || this.sources.length == 0) {
            return null;
        }
        if (controlType.equals("javax.media.protocol.PushDataSource")) {
            return this;
        }
        if (controlType.equals("javax.tv.media.protocol.PushSourceStream")) {
            return this.sources[0];
        }
        if (controlType.equals("javax.tv.media.protocol.PushSourceStream2")) {
            return this.sources[0];
        }
        return null;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }
}

