/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.protocol.file;

import com.sun.tv.media.util.JMFI18N;
import com.sun.tv.media.util.JMFSecurity;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class DataSource
extends PullDataSource {
    protected RandomAccessFile raf;
    private boolean connected = false;
    protected long length = -1L;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        URL url;
        if (this.connected) {
            return;
        }
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            System.err.println("medialocator is null");
            throw new IOException(this + ": connect() failed");
        }
        try {
            url = locator.getURL();
        }
        catch (MalformedURLException e) {
            System.err.println(this.getLocator() + ": Don't know how to deal with non-URL locator yet!");
            throw new IOException(this + ": connect() failed");
        }
        try {
            String fileName;
            try {
                JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.readFileArgs);
            }
            catch (Exception e) {
                // empty catch block
            }
            URLConnection urlC = url.openConnection();
            this.contentType = urlC.getContentType();
            this.contentType = this.getCorrectedContentType(this.contentType);
            this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
            String saved = fileName = locator.getRemainder();
            try {
                int idx = 0;
                while ((idx = fileName.indexOf("%", idx)) >= 0) {
                    if (fileName.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(fileName.substring(idx + 1, idx + 3), 16).intValue();
                            fileName = fileName.substring(0, idx) + new String(bytes) + fileName.substring(idx + 3);
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
                idx = 0;
                while ((idx = fileName.indexOf("|")) >= 0) {
                    if (idx > 0) {
                        fileName = fileName.substring(0, idx) + ":" + fileName.substring(idx + 1);
                        continue;
                    }
                    fileName = fileName.substring(1);
                }
                while (fileName.charAt(0) == '/' && (fileName.charAt(1) == '/' || fileName.charAt(2) == ':')) {
                    fileName = fileName.substring(1);
                }
            }
            catch (Exception e) {
                fileName = saved;
            }
            this.raf = new RandomAccessFile(fileName, "r");
            this.length = this.raf.length();
            if (this.length < 0L) {
                this.length = -1L;
            }
            RAFPullSourceStream pss = new RAFPullSourceStream();
            this.pssArray[0] = pss;
            this.connected = true;
        }
        catch (IOException ioe) {
            throw new IOException(JMFI18N.getResource("error.filenotfound"));
        }
    }

    public void disconnect() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pssArray != null) {
            this.pssArray[0] = null;
        }
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setLocator(MediaLocator ml) {
        if (ml != null && ml.getProtocol() != null && ml.getProtocol().equals("file")) {
            MediaLocator saved = ml;
            String file = ml.getRemainder();
            boolean changed = false;
            if (file == null) {
                super.setLocator(ml);
                return;
            }
            try {
                int idx = 0;
                while ((idx = file.indexOf("%", idx)) >= 0) {
                    if (file.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(file.substring(idx + 1, idx + 3), 16).intValue();
                            file = file.substring(0, idx) + new String(bytes) + file.substring(idx + 3);
                            changed = true;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
                if (changed) {
                    ml = new MediaLocator(ml.getProtocol() + ":" + file);
                }
            }
            catch (Exception e) {
                ml = saved;
            }
        }
        super.setLocator(ml);
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    protected String getCorrectedContentType(String contentType) {
        if (contentType != null) {
            String type;
            if (contentType.equals("audio/wav")) {
                contentType = "audio/x-wav";
            } else if (contentType.equals("audio/aiff")) {
                contentType = "audio/x-aiff";
            } else if (contentType.equals("application/x-troff-msvideo")) {
                contentType = "video/x-msvideo";
            } else if (contentType.equals("video/msvideo")) {
                contentType = "video/x-msvideo";
            } else if (contentType.equals("video/avi")) {
                contentType = "video/x-msvideo";
            } else if (contentType.equals("audio/x-mpegaudio")) {
                contentType = "audio/mpeg";
            } else if (contentType.equals("content/unknown") && (type = this.guessContentType(this.getLocator())) != null) {
                contentType = type;
            }
        } else {
            contentType = "content/unknown";
        }
        return contentType;
    }

    private String guessContentType(MediaLocator locator) {
        String path = locator.getRemainder();
        int i = path.lastIndexOf(".");
        if (i != -1) {
            String ext = path.substring(i + 1).toLowerCase();
            if (ext.equals("mov")) {
                return "video/quicktime";
            }
            if (ext.equals("avi")) {
                return "video/x_msvideo";
            }
            if (ext.equals("mpg")) {
                return "video/mpeg";
            }
            if (ext.equals("mpv")) {
                return "video/mpeg";
            }
            if (ext.equals("viv")) {
                return "video/vivo";
            }
            if (ext.equals("au")) {
                return "audio/basic";
            }
            if (ext.equals("wav")) {
                return "audio/x_wav";
            }
            if (ext.startsWith("aif")) {
                return "audio/x_aiff";
            }
            if (ext.equals("mid") || ext.equals("midi")) {
                return "audio/midi";
            }
            if (ext.equals("rmf")) {
                return "audio/rmf";
            }
            if (ext.equals("gsm")) {
                return "audio/x_gsm";
            }
            if (ext.equals("mp2")) {
                return "audio/mpeg";
            }
            if (ext.equals("mp3")) {
                return "audio/mpeg";
            }
            if (ext.equals("mpa")) {
                return "audio/mpeg";
            }
            if (ext.equals("swf")) {
                return "application/x-shockwave-flash";
            }
            if (ext.equals("spl")) {
                return "application/futuresplash";
            }
        }
        return null;
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        RAFPullSourceStream() {
        }

        public long seek(long where) {
            try {
                DataSource.this.raf.seek(where);
                return this.tell();
            }
            catch (IOException e) {
                System.out.println("seek: " + e);
                return -1L;
            }
        }

        public long tell() {
            try {
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException e) {
                System.out.println("tell: " + e);
                return -1L;
            }
        }

        public boolean isRandomAccess() {
            return true;
        }

        public boolean willReadBlock() {
            return false;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return DataSource.this.raf.read(buffer, offset, length);
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return DataSource.this.length;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlType) {
            return null;
        }
    }
}

