/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.protocol.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Vector;
import javax.media.Control;
import javax.media.PackageManager;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.SourceTransferHandler;
import javax.tv.media.protocol.DataLostException;
import javax.tv.media.protocol.PushSourceStream2;

public class PushSourceStream2Impl
implements PushSourceStream2 {
    protected boolean eos = false;
    protected long contentLength = -1L;
    protected SourceTransferHandler sth = null;
    protected ContentDescriptor contentType;
    protected InputStream inputStream;

    public PushSourceStream2Impl(URLConnection urlConnection, ContentDescriptor contentDesc) throws IOException {
        this.contentType = contentDesc;
        this.contentLength = urlConnection.getContentLength();
        if (this.contentLength < 1L) {
            this.contentLength = -1L;
        }
        this.inputStream = urlConnection.getInputStream();
    }

    public static void registerServiceProtocol() {
        String ServiceProtocol = "service";
        String ProtocolPrefix = "com.sun.tv";
        Vector<String> list = PackageManager.getProtocolPrefixList();
        if (list == null) {
            list = new Vector<String>();
        }
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            String cur = (String)list.elementAt(i);
            if (!ProtocolPrefix.equalsIgnoreCase(cur)) continue;
            found = true;
        }
        if (!found) {
            list.addElement(ProtocolPrefix);
        }
        PackageManager.setProtocolPrefixList(list);
    }

    public int readStream(byte[] buffer, int offset, int length) throws IOException, DataLostException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("length < 0");
        }
        if (offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("(offset+length) > buffer.length");
        }
        return this.read(buffer, offset, length);
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length < 0) {
            return 0;
        }
        if (this.endOfStream()) {
            return -1;
        }
        int canRead = buffer.length - offset;
        if (canRead <= 0) {
            return 0;
        }
        if (canRead > length) {
            canRead = length;
        }
        if (this.available() == 0) {
            return 0;
        }
        if (this.available() < canRead) {
            canRead = this.available();
        }
        try {
            return this.inputStream.read(buffer, offset, canRead);
        }
        catch (IOException ioe) {
            this.eos = true;
            return -1;
        }
    }

    public int getMinimumTransferSize() {
        return 8192;
    }

    public void setTransferHandler(SourceTransferHandler transferHandler) {
        if (transferHandler == null) {
            throw new NullPointerException("setTransferHandler(null)");
        }
        this.sth = transferHandler;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean endOfStream() {
        if (this.available() > 0) {
            return false;
        }
        return this.eos;
    }

    public Object[] getControls() {
        return new Control[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    private int available() {
        if (this.inputStream == null) {
            return 0;
        }
        try {
            return this.inputStream.available();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

