/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.util;

import com.sun.tv.media.util.JMFI18N;
import com.sun.tv.media.util.JMFSecurity;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JMFProperties {
    private static String filename = null;
    private static Properties jmfProps = null;
    private static boolean useNative = false;

    public static void setProperty(String prop, String value) {
        if (jmfProps == null) {
            JMFProperties.readProperties();
        }
        ((Hashtable)jmfProps).put(prop, value);
    }

    public static String getProperty(String prop) {
        if (jmfProps == null) {
            JMFProperties.readProperties();
        }
        return jmfProps.getProperty(prop, null);
    }

    public static void readProperties_old() {
        JMFProperties foo = new JMFProperties();
        try {
            Method m = foo.getClass().getMethod("readProperties_1", null);
            JMFSecurity.callPrivileged(m, foo, null);
        }
        catch (Exception e) {
            System.err.println("A privileged call failed: " + e);
            e.printStackTrace();
        }
    }

    public static final void readProperties() {
        System.out.println("JMFProperties: readProperties");
        if (jmfProps != null) {
            return;
        }
        if (!useNative) {
            jmfProps = new Properties();
            ((Hashtable)jmfProps).put("content.prefixes", "com.sun.tv");
            ((Hashtable)jmfProps).put("protocol.prefixes", "com.sun.tv");
            ((Hashtable)jmfProps).put("cache.limit", "2000000");
            ((Hashtable)jmfProps).put("cache.dir", "/tmp");
            ((Hashtable)jmfProps).put("cache.use", "N");
            ((Hashtable)jmfProps).put("defaultfont.name", "Helvetica");
            return;
        }
        try {
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.readPropArgs);
        }
        catch (Exception e) {
            // empty catch block
        }
        String classpath = null;
        try {
            classpath = System.getProperty("java.class.path");
        }
        catch (Exception e) {
            filename = null;
            System.err.println("Error: Couldn't read the CLASSPATH " + e);
            jmfProps = new Properties();
            ((Hashtable)jmfProps).put("content.prefixes", "javax|com.sun.tv|test");
            ((Hashtable)jmfProps).put("protocol.prefixes", "javax|com.sun.tv|test");
            ((Hashtable)jmfProps).put("cache.limit", "2000000");
            ((Hashtable)jmfProps).put("cache.dir", "/tmp");
            ((Hashtable)jmfProps).put("cache.use", "N");
            ((Hashtable)jmfProps).put("defaultfont.name", "Helvetica");
            return;
        }
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        String strJMF = JMFI18N.getResource("jmf.properties");
        while (tokens.hasMoreTokens()) {
            String dir = tokens.nextToken();
            String caps = dir.toUpperCase();
            try {
                if (caps.indexOf(".ZIP") > 0 || caps.indexOf(".JAR") > 0) {
                    int sep = dir.lastIndexOf(File.separator);
                    if (sep == -1 && !File.separator.equals("/")) {
                        sep = dir.lastIndexOf("/");
                    }
                    dir = sep == -1 ? ((sep = dir.lastIndexOf(":")) == -1 ? strJMF : dir.substring(0, sep) + ":" + strJMF) : dir.substring(0, sep) + File.separator + strJMF;
                } else {
                    dir = dir + File.separator + strJMF;
                }
            }
            catch (Exception e) {
                dir = dir + File.separator + strJMF;
            }
            File file = new File(dir);
            if (JMFProperties.nFileExists(dir)) {
                filename = dir;
                JMFProperties.readTheFile(dir, file);
                return;
            }
            if (strJMF.equals("jmf.properties") || !JMFProperties.nFileExists(dir = dir.substring(0, dir.length() - 3))) continue;
            filename = dir;
            JMFProperties.readTheFile(dir, file);
            return;
        }
        jmfProps = new Properties();
        ((Hashtable)jmfProps).put("content.prefixes", "javax|com.sun.tv|test");
        ((Hashtable)jmfProps).put("protocol.prefixes", "javax|com.sun.tv|test");
        ((Hashtable)jmfProps).put("cache.limit", "2000000");
        ((Hashtable)jmfProps).put("cache.dir", "/tmp");
        ((Hashtable)jmfProps).put("cache.use", "N");
        ((Hashtable)jmfProps).put("defaultfont.name", "Helvetica");
    }

    private static void readTheFile(String filename, File file) {
        jmfProps = new Properties();
        JMFProperties.pleaseReadTheFile(filename, file);
    }

    public static boolean writeProperties() {
        if (jmfProps == null) {
            JMFProperties.readProperties();
        }
        if (jmfProps != null && filename != null) {
            File file = new File(filename);
            return JMFProperties.pleaseWriteTheFile(filename, file);
        }
        return false;
    }

    private static native boolean nFileExists(String var0);

    private static native int nOpenFile(String var0, int var1);

    private static native String nReadLine(int var0);

    private static native void nCloseFile(int var0);

    private static native void nWriteLine(int var0, String var1);

    private static synchronized void pleaseReadTheFile(String filename, File file) {
        int id = JMFProperties.nOpenFile(filename, 0);
        if (id != 0) {
            String line;
            while ((line = JMFProperties.nReadLine(id)) != null) {
                int equal = line.indexOf("=");
                if (equal <= 0 || equal >= line.length() - 1) continue;
                String key = line.substring(0, equal);
                String value = line.substring(equal + 1, line.length());
                ((Hashtable)jmfProps).put(key, value);
            }
            JMFProperties.nCloseFile(id);
        } else {
            System.err.println("Can't read jmf.properties file");
        }
    }

    private static boolean pleaseWriteTheFile(String filename, File file) {
        int id = JMFProperties.nOpenFile(filename, 1);
        if (id != 0) {
            JMFProperties.nWriteLine(id, "#JMFProperties");
            Enumeration<?> enumeration = jmfProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = jmfProps.getProperty(key);
                if (key == null || value == null) continue;
                JMFProperties.nWriteLine(id, key + "=" + value);
            }
            JMFProperties.nCloseFile(id);
            return true;
        }
        System.err.println("Can't write jmf.properties file");
        return false;
    }

    public static Vector str2list(String str) {
        Vector<String> list = new Vector<String>();
        if (str == null) {
            return list;
        }
        int i = 0;
        while ((i = str.indexOf("|")) != -1) {
            list.addElement(str.substring(0, i));
            str = str.substring(i + 1);
        }
        list.addElement(str);
        return list;
    }

    static {
        JMFSecurity.beginPrivileged();
        try {
            JMFSecurity.loadLibrary("jmam");
        }
        catch (UnsatisfiedLinkError e) {
            useNative = false;
        }
        catch (Exception e) {
            useNative = false;
        }
        try {
            JMFProperties.readProperties();
        }
        catch (Exception e) {
            System.err.println("JMFProperties: could not read properties.");
        }
        JMFSecurity.endPrivileged();
    }
}

