/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.net.EncapIPStream;
import java.io.IOException;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.locator.MalformedLocatorException;

public class EncapIPDataSource
extends PushDataSource {
    EncapIPStream stream = null;

    public EncapIPDataSource(MediaLocator mediaLoc) throws MalformedLocatorException {
        LocatorFactory locFact = LocatorFactory.getInstance();
        Locator tvLoc = locFact.createLocator(mediaLoc.toExternalForm());
        try {
            this.stream = new EncapIPStream(tvLoc);
        }
        catch (InvalidLocatorException e) {
            System.err.println(e);
        }
    }

    public String getContentType() {
        return new String("encapsulated IP datagram");
    }

    public void connect() throws IOException {
        if (this.stream == null) {
            throw new IOException("no stream for the IP data source");
        }
        this.stream.setOpen(true);
    }

    public void disconnect() {
        if (this.stream != null) {
            this.stream.setOpen(false);
        }
    }

    public void start() throws IOException {
        if (this.stream == null) {
            throw new IOException("no stream for the IP data source");
        }
        this.stream.setTransfer(true);
    }

    public void stop() throws IOException {
        if (this.stream == null) {
            throw new IOException("no stream for the IP data source");
        }
        this.stream.setTransfer(false);
    }

    public Object[] getControls() {
        return null;
    }

    public Object getControl(String control) {
        return null;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public PushSourceStream[] getStreams() {
        PushSourceStream[] streams = new PushSourceStream[1];
        if (this.stream != null) {
            streams[0] = this.stream;
            return streams;
        }
        return null;
    }
}

