/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.net.Fragment;
import com.sun.tv.net.Packet;
import com.sun.tv.net.Reassembler;
import com.sun.tv.net.ReassemblerTimer;

class IPReass {
    private static final long REASSEMBLY_TIMEOUT = 30000L;
    private static Reassembler reassemblers;
    private static ReassemblerTimer timer;
    private static int ipReasmFails;
    private static boolean debug;

    IPReass() {
    }

    static int getipReasmFails() {
        return ipReasmFails;
    }

    static void timeout() {
        long currentTime = System.currentTimeMillis();
        while (reassemblers != null) {
            Reassembler reass = IPReass.reassemblers.prev;
            if (reass.timeout <= currentTime) {
                ++ipReasmFails;
                IPReass.remove(reass);
                continue;
            }
            timer.start(reass.timeout - currentTime);
            break;
        }
    }

    private static void remove(Reassembler reass) {
        if (reass.next == reass) {
            reassemblers = null;
            timer.stop();
        } else {
            if (reassemblers == reass) {
                reassemblers = reass.next;
            }
            reass.prev.next = reass.next;
            reass.next.prev = reass.prev;
        }
        reass.recycle();
    }

    private static void insert(Reassembler reass) {
        if (reassemblers == null) {
            timer.start(30000L);
            reass.next = reass;
            reass.prev = reass;
        } else {
            reass.next = reassemblers;
            reass.prev = IPReass.reassemblers.prev;
            IPReass.reassemblers.prev.next = reass;
            IPReass.reassemblers.prev = reass;
        }
        reassemblers = reass;
        reass.timeout = System.currentTimeMillis() + 30000L;
    }

    private static Reassembler find(int id, int src_ip, int dst_ip, int prot) {
        Reassembler reass = reassemblers;
        if (reass != null) {
            do {
                if (reass.ident != id || reass.src_ip != src_ip || reass.dst_ip != dst_ip || reass.prot != prot) continue;
                return reass;
            } while ((reass = reass.next) != reassemblers);
        }
        return null;
    }

    static boolean recycleOldest() {
        Reassembler reass = IPReass.reassemblers.prev;
        if (reassemblers == reass) {
            return false;
        }
        IPReass.remove(reass);
        return true;
    }

    static Packet insertFragment(Packet pkt, int id, int src_ip, int dst_ip, int prot, int offset) {
        Fragment frag = Fragment.get(pkt.copy());
        if (frag == null) {
            pkt.setLength(0);
            return pkt;
        }
        Reassembler reass = IPReass.find(id, src_ip, dst_ip, prot);
        if (reass != null) {
            pkt = reass.add(frag, offset);
            if (pkt != null) {
                IPReass.remove(reass);
            }
            return pkt;
        }
        reass = Reassembler.get(id, src_ip, dst_ip, prot);
        if (reass == null) {
            pkt.setLength(0);
            return pkt;
        }
        pkt = reass.add(frag, offset);
        if (pkt == null) {
            IPReass.insert(reass);
        } else {
            reass.recycle();
        }
        return pkt;
    }

    private static void dprint(String s) {
        if (debug) {
            IPReass.err(s);
        }
    }

    private static void err(String s) {
        System.err.println("IPReass: " + s);
    }

    static {
        timer = new ReassemblerTimer();
        debug = true;
    }
}

