/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.receiver.Settings;
import com.sun.tv.si.RatingDimensionImpl;
import java.util.Vector;
import javax.tv.service.SIException;
import javax.tv.service.guide.ContentRatingAdvisory;

public class ContentRatingAdvisoryImpl
implements ContentRatingAdvisory {
    private Vector dimensionNames;
    private Vector longNames;

    public ContentRatingAdvisoryImpl(Vector dimensionNames, Vector longNames) {
        this.dimensionNames = dimensionNames != null ? dimensionNames : new Vector();
        this.longNames = longNames != null ? longNames : new Vector();
    }

    public String[] getDimensionNames() {
        Vector temp = new Vector();
        for (int i = 0; i < this.dimensionNames.size(); ++i) {
            RatingDimensionImpl rating = (RatingDimensionImpl)RatingDimensionImpl.getRatingDimension((String)this.dimensionNames.elementAt(i));
            if (rating == null) continue;
            temp.addElement(this.dimensionNames.elementAt(i));
        }
        String[] names = new String[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            names[i] = (String)temp.elementAt(i);
        }
        return names;
    }

    public short getRatingLevel(String ratedDimension) throws SIException {
        if (ratedDimension == null) {
            throw new NullPointerException("ratedDimension == null");
        }
        String longName = this.getRatingLevelText(ratedDimension);
        if (longName == null) {
            throw new SIException("Invalid ratedDimension " + ratedDimension);
        }
        short level = this.findRatingLevel(ratedDimension, longName);
        if (level == -1) {
            throw new SIException("Invalid ratedDimension " + ratedDimension);
        }
        return level;
    }

    public String getRatingLevelText(String dimensionName) throws SIException {
        if (dimensionName == null) {
            throw new NullPointerException("dimensionName == null");
        }
        for (int i = 0; i < this.dimensionNames.size(); ++i) {
            String name = (String)this.dimensionNames.elementAt(i);
            if (name == null || !dimensionName.equalsIgnoreCase(name)) continue;
            return (String)this.longNames.elementAt(i);
        }
        throw new SIException("Invalid dimensionName " + dimensionName);
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.dimensionNames.size(); ++i) {
            String name = (String)this.dimensionNames.elementAt(i);
            try {
                buf.append(this.getRatingLevelText(name));
                if (i >= this.dimensionNames.size() + 1) continue;
                buf.append(",");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    public boolean exceeds() {
        for (int i = 0; i < this.dimensionNames.size(); ++i) {
            String name = (String)this.dimensionNames.elementAt(i);
            try {
                short eventLevel = this.getRatingLevel(name);
                short receiverLevel = this.getReceiverRatingLevel(name);
                if (receiverLevel == -1 || receiverLevel >= eventLevel) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private short getReceiverRatingLevel(String dimensionName) {
        for (int i = 0; i < Settings.ReceiverRatingNames.length; ++i) {
            if (!dimensionName.equals(Settings.ReceiverRatingNames[i])) continue;
            String longName = Settings.ReceiverRatingLevels[i];
            return this.findRatingLevel(dimensionName, longName);
        }
        return -1;
    }

    private short findRatingLevel(String dimensionName, String longName) {
        RatingDimensionImpl rating = (RatingDimensionImpl)RatingDimensionImpl.getRatingDimension(dimensionName);
        if (rating == null) {
            return -1;
        }
        return rating.findRatingLevel(longName);
    }
}

