/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.SIRequestImpl;
import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.transport.Network;

public class NetworkImpl
implements Network {
    private String name = null;
    private int networkID = -1;
    private Date updatedTime = null;
    private Locator locator = null;
    private ServiceInformationType siType;

    public NetworkImpl(String name, int networkID, ServiceInformationType siType, Date updatedTime) {
        this.name = name;
        this.networkID = networkID;
        this.siType = siType;
        this.updatedTime = updatedTime;
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public String getName() {
        return this.name;
    }

    public Locator getLocator() {
        if (this.locator == null) {
            try {
                this.locator = LocatorFactory.getInstance().createLocator("network:/" + this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.locator;
    }

    public Date getUpdateTime() {
        return this.updatedTime;
    }

    public ServiceInformationType getServiceInformationType() {
        return this.siType;
    }

    public SIRequest retrieveTransportStreams(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator streamsLocator = LocatorImpl.transformToTransportStream(this.getLocator());
        int reqKind = 8;
        return new SIRequestImpl(requestor, streamsLocator, reqKind, this);
    }
}

