/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.SIManagerImpl;
import com.sun.tv.si.SIRequestImpl;
import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.SIManager;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.guide.ContentRatingAdvisory;
import javax.tv.service.guide.ProgramEvent;

public class ProgramEventImpl
implements ProgramEvent {
    private String programName;
    private String serviceName;
    private Date startTime;
    private Date endTime;
    private Locator locator;
    private ServiceInformationType siType;
    private Date updatedTime;
    private ContentRatingAdvisory rating;

    public ProgramEventImpl(String programName, String serviceName, Date startTime, Date endTime, ServiceInformationType siType, ContentRatingAdvisory rating, Date updatedTime) {
        this.programName = programName;
        this.serviceName = serviceName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.siType = siType;
        this.updatedTime = updatedTime;
        this.rating = rating;
        try {
            String locatorStr = "event:/" + programName + "service:/" + serviceName;
            this.locator = LocatorFactory.getInstance().createLocator(locatorStr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return (this.endTime.getTime() - this.startTime.getTime()) / 1000L;
    }

    public String getName() {
        return this.programName;
    }

    public SIRequest retrieveDescription(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator descLocator = LocatorImpl.transformToProgramEventDescription(this.getLocator());
        return new SIRequestImpl(requestor, descLocator);
    }

    public ContentRatingAdvisory getRating() {
        return this.rating;
    }

    public Service getService() {
        try {
            String str = "service:/" + this.serviceName;
            Locator serviceLoc = LocatorFactory.getInstance().createLocator(str);
            return ((SIManagerImpl)SIManager.createInstance()).getService(serviceLoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SIRequest retrieveComponents(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        int reqKind = 1;
        return new SIRequestImpl(requestor, this.getLocator(), reqKind);
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Date getUpdateTime() {
        return this.updatedTime;
    }

    public ServiceInformationType getServiceInformationType() {
        return this.siType;
    }

    public long compareTo(Date current) {
        long startTime = this.getStartTime().getTime();
        long endTime = this.getEndTime().getTime() - 1000L;
        long curTime = current.getTime();
        long dxTime = startTime - curTime;
        if (dxTime > 0L) {
            return dxTime;
        }
        dxTime = endTime - curTime;
        if (dxTime < 0L) {
            return dxTime;
        }
        return 0L;
    }

    public boolean isIncluded(Date current) {
        return current.getTime() >= this.getStartTime().getTime() && current.getTime() < this.getEndTime().getTime();
    }
}

