/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.service.RatingDimension;
import javax.tv.service.SIException;

public class RatingDimensionImpl
implements RatingDimension {
    private static Hashtable ratingDimensions = new Hashtable();
    String name = null;
    Vector list = new Vector();

    public RatingDimensionImpl(String name) {
        this.name = name;
        ratingDimensions.put(name, this);
    }

    public void addRatingLevelDescription(String shortName, String fullName) {
        String[] namePair = new String[]{new String(shortName), new String(fullName)};
        this.list.addElement(namePair);
    }

    public String getDimensionName() {
        return this.name;
    }

    public short getNumberOfLevels() {
        return (short)this.list.size();
    }

    public String[] getRatingLevelDescription(short ratingLevel) throws SIException {
        if (ratingLevel < 0 || ratingLevel >= this.list.size()) {
            throw new SIException(ratingLevel + " < 0 or >= " + this.list.size());
        }
        return (String[])this.list.elementAt(ratingLevel);
    }

    public static String[] getSupportedDimensions() {
        int count = 0;
        Enumeration list = ratingDimensions.keys();
        while (list.hasMoreElements()) {
            list.nextElement();
            ++count;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] strs = new String[count];
        count = 0;
        list = ratingDimensions.keys();
        while (list.hasMoreElements()) {
            strs[count++] = (String)list.nextElement();
        }
        return strs;
    }

    public short findRatingLevel(String longName) {
        for (int i = 0; i < this.list.size(); ++i) {
            String[] pair = (String[])this.list.elementAt(i);
            if (!longName.equals(pair[1])) continue;
            return (short)i;
        }
        return -1;
    }

    public static RatingDimension getRatingDimension(String name) {
        if (name == null) {
            return null;
        }
        return (RatingDimension)ratingDimensions.get(name);
    }
}

