/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.NotifyServiceComponentChangeThread;
import com.sun.tv.si.ProgramScheduleImpl;
import com.sun.tv.si.SIRequestImpl;
import com.sun.tv.si.ServiceImpl;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.Locator;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.ServiceType;
import javax.tv.service.guide.ProgramSchedule;
import javax.tv.service.navigation.DeliverySystemType;
import javax.tv.service.navigation.ServiceComponentChangeEvent;
import javax.tv.service.navigation.ServiceComponentChangeListener;
import javax.tv.service.navigation.ServiceDetails;
import javax.tv.service.navigation.ServiceProviderInformation;

public class ServiceDetailsImpl
implements ServiceDetails,
ServiceProviderInformation {
    private static Hashtable listenerTable = new Hashtable();
    private ServiceImpl service;
    private Date updatedTime;
    private ProgramSchedule schedule = null;
    private DeliverySystemType deliverySystemType;
    private String longname;
    private int[] caSystemIDs;
    private String providerName;

    public ServiceDetailsImpl(ServiceImpl service, String providerName, DeliverySystemType deliverySystemType, String longname, int[] caSystemIDs, Date updatedTime) {
        this.service = service;
        this.providerName = providerName;
        this.deliverySystemType = deliverySystemType;
        this.longname = longname;
        this.caSystemIDs = caSystemIDs;
        this.updatedTime = updatedTime;
        this.schedule = new ProgramScheduleImpl(service);
    }

    public SIRequest retrieveServiceDescription(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor is null");
        }
        Locator locatorDesc = LocatorImpl.transformToServiceDescription(this.getLocator());
        return new SIRequestImpl(requestor, locatorDesc);
    }

    public ServiceType getServiceType() {
        return this.service.getServiceType();
    }

    public SIRequest retrieveComponents(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor is null");
        }
        int reqKind = 1;
        return new SIRequestImpl(requestor, this.getLocator(), reqKind);
    }

    public ProgramSchedule getProgramSchedule() {
        return this.schedule;
    }

    public String getLongName() {
        return this.longname;
    }

    public Service getService() {
        return this.service;
    }

    public int[] getCASystemIDs() {
        return this.caSystemIDs;
    }

    public boolean isFree() {
        return this.caSystemIDs == null || this.caSystemIDs.length == 0;
    }

    public DeliverySystemType getDeliverySystemType() {
        return this.deliverySystemType;
    }

    public Locator getLocator() {
        return this.getService().getLocator();
    }

    public Date getUpdateTime() {
        return this.updatedTime;
    }

    public ServiceInformationType getServiceInformationType() {
        return this.service.getServiceInformationType();
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void addServiceComponentChangeListener(ServiceComponentChangeListener listener) throws SecurityException {
        if (listener == null) {
            throw new NullPointerException("ServiceComponentChangeListener null");
        }
        Vector listeners = this.getListeners();
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeServiceComponentChangeListener(ServiceComponentChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("ServiceComponentChangeListener null");
        }
        Vector listeners = this.getListeners();
        listeners.removeElement(listener);
    }

    private Vector getListeners() {
        String key = this.getLocator().toExternalForm();
        Vector listeners = (Vector)listenerTable.get(key);
        if (listeners == null) {
            listeners = new Vector();
            listenerTable.put(key, listeners);
        }
        return listeners;
    }

    public void notifyListeners(ServiceComponentChangeEvent event) {
        Vector listeners = this.getListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceComponentChangeListener listener = (ServiceComponentChangeListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    private void notifyAsyncListener(ServiceComponentChangeEvent event, ServiceComponentChangeListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifyServiceComponentChangeThread thread = new NotifyServiceComponentChangeThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }
}

