/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.SIRequestImpl;
import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.SIElement;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.ServiceMinorNumber;
import javax.tv.service.ServiceNumber;
import javax.tv.service.ServiceType;

public class ServiceImpl
implements Service,
SIElement,
ServiceNumber,
ServiceMinorNumber {
    private String serviceName;
    private ServiceType sType;
    private Locator locator = null;
    private ServiceInformationType siType;
    private Date updatedTime;
    private int serviceNumber;
    private int minorNumber;
    private int presentationTerminatedReason = 0;
    private int selectionFailedReason = 0;

    public ServiceImpl(String serviceName, boolean hasMultiples, ServiceType sType, ServiceInformationType siType, int serviceNumber, int minorNumber, Date updatedTime) {
        this.serviceName = serviceName;
        this.sType = sType;
        this.siType = siType;
        this.serviceNumber = serviceNumber;
        this.minorNumber = minorNumber;
        this.updatedTime = updatedTime;
    }

    public String getName() {
        return this.serviceName;
    }

    public boolean hasMultipleInstances() {
        return this.getLocator().hasMultipleTransformations();
    }

    public ServiceType getServiceType() {
        return this.sType;
    }

    public Locator getLocator() {
        if (this.locator == null) {
            try {
                String locatorStr = "service:/" + this.serviceName;
                this.locator = LocatorFactory.getInstance().createLocator(locatorStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.locator;
    }

    public Date getUpdateTime() {
        return this.updatedTime;
    }

    public ServiceInformationType getServiceInformationType() {
        return this.siType;
    }

    public int getServiceNumber() {
        return this.serviceNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public SIRequest retrieveDetails(SIRequestor requestor) {
        Locator[] locs;
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator loc = this.getLocator();
        if (LocatorImpl.isTIService(this.locator) && (locs = LocatorImpl.transformLocator(this.locator)) != null && locs.length > 0) {
            loc = locs[0];
        }
        return new SIRequestImpl(requestor, loc);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceImpl)) {
            return false;
        }
        Service s = (Service)obj;
        if (!s.getLocator().equals(this.getLocator())) {
            return false;
        }
        return s.getName().equals(this.getName()) && s.getServiceType() == this.getServiceType() && s.hasMultipleInstances() == this.hasMultipleInstances();
    }

    public int hashCode() {
        return this.getLocator().hashCode();
    }

    public void setPresentationTerminatedReason(int reason) {
        this.presentationTerminatedReason = reason;
    }

    public int getPresentationTerminatedReason() {
        return this.presentationTerminatedReason;
    }

    public void setSelectionFailedReason(int reason) {
        this.selectionFailedReason = reason;
    }

    public int getSelectionFailedReason() {
        return this.selectionFailedReason;
    }
}

