/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.NotifySIChangeThread;
import com.sun.tv.si.SIRequestImpl;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.ReadPermission;
import javax.tv.service.SIChangeEvent;
import javax.tv.service.SIChangeListener;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.navigation.DeliverySystemType;
import javax.tv.service.transport.BouquetChangeEvent;
import javax.tv.service.transport.BouquetChangeListener;
import javax.tv.service.transport.BouquetCollection;
import javax.tv.service.transport.NetworkChangeEvent;
import javax.tv.service.transport.NetworkChangeListener;
import javax.tv.service.transport.NetworkCollection;
import javax.tv.service.transport.ServiceDetailsChangeEvent;
import javax.tv.service.transport.ServiceDetailsChangeListener;
import javax.tv.service.transport.TransportStreamChangeEvent;
import javax.tv.service.transport.TransportStreamChangeListener;
import javax.tv.service.transport.TransportStreamCollection;

public class TransportImpl
implements BouquetCollection,
NetworkCollection,
TransportStreamCollection {
    private static Hashtable detailsListeners = new Hashtable();
    private static Hashtable bouquetListeners = new Hashtable();
    private static Hashtable networkListeners = new Hashtable();
    private static Hashtable transportStreamListeners = new Hashtable();
    private int transportID = -1;
    private DeliverySystemType deliverySystemType;
    private Locator locator = null;

    public TransportImpl(int transportID, DeliverySystemType deliverySystemType) {
        this.transportID = transportID;
        this.deliverySystemType = deliverySystemType;
    }

    public DeliverySystemType getDeliverySystemType() {
        return this.deliverySystemType;
    }

    public void addServiceDetailsChangeListener(ServiceDetailsChangeListener listener) throws SecurityException {
        if (listener == null) {
            throw new NullPointerException("SIChangeListener null");
        }
        Vector listeners = this.getListeners(detailsListeners);
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeServiceDetailsChangeListener(ServiceDetailsChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("SIChangeListener null");
        }
        Vector listeners = this.getListeners(detailsListeners);
        listeners.removeElement(listener);
    }

    public void notifyServiceDetailsListeners(ServiceDetailsChangeEvent event) {
        Vector listeners = this.getListeners(detailsListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceDetailsChangeListener listener = (ServiceDetailsChangeListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    public SIRequest retrieveBouquet(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator null");
        }
        if (!LocatorImpl.isBouquet(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public SIRequest retrieveBouquets(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator bouquetLocator = null;
        try {
            bouquetLocator = LocatorFactory.getInstance().createLocator("bouquet:/*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SIRequestImpl(requestor, bouquetLocator);
    }

    public SIRequest retrieveNetwork(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator is null");
        }
        if (!LocatorImpl.isNetwork(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public SIRequest retrieveNetworks(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator networkLocator = null;
        try {
            networkLocator = LocatorFactory.getInstance().createLocator("network:/*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SIRequestImpl(requestor, networkLocator);
    }

    public SIRequest retrieveTransportStream(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator is null");
        }
        if (!LocatorImpl.isTransportStream(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public SIRequest retrieveTransportStreams(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        Locator tsLocator = null;
        try {
            tsLocator = LocatorFactory.getInstance().createLocator("transport:/*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SIRequestImpl(requestor, tsLocator);
    }

    public SIRequest retrieveTransportStreams(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        Locator transportLocator;
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator is null");
        }
        if (!LocatorImpl.isNetwork(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        if ((transportLocator = LocatorImpl.transformToTransportStream(locator)) == null) {
            throw new InvalidLocatorException(transportLocator);
        }
        return new SIRequestImpl(requestor, transportLocator);
    }

    public void addBouquetChangeListener(BouquetChangeListener listener) throws SecurityException {
        if (listener == null) {
            throw new NullPointerException("BouquetChangeListener null");
        }
        Vector listeners = this.getListeners(bouquetListeners);
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeBouquetChangeListener(BouquetChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("BouquetChangeListener null");
        }
        Vector listeners = this.getListeners(bouquetListeners);
        listeners.removeElement(listener);
    }

    public void notifyBouquetListeners(BouquetChangeEvent event) {
        Vector listeners = this.getListeners(bouquetListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            BouquetChangeListener listener = (BouquetChangeListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    public void addNetworkChangeListener(NetworkChangeListener listener) throws SecurityException {
        if (listener == null) {
            throw new NullPointerException("NetworkChangeListener null");
        }
        Vector listeners = this.getListeners(networkListeners);
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeNetworkChangeListener(NetworkChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("NetworkChangeListener null");
        }
        Vector listeners = this.getListeners(networkListeners);
        listeners.removeElement(listener);
    }

    public void notifyNetworkListeners(NetworkChangeEvent event) {
        Vector listeners = this.getListeners(networkListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            NetworkChangeListener listener = (NetworkChangeListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    public void addTransportStreamChangeListener(TransportStreamChangeListener listener) throws SecurityException {
        if (listener == null) {
            throw new NullPointerException("TransportStreamChangeListener null");
        }
        Vector listeners = this.getListeners(transportStreamListeners);
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeTransportStreamChangeListener(TransportStreamChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("TransportStreamChangeListener null");
        }
        Vector listeners = this.getListeners(transportStreamListeners);
        listeners.removeElement(listener);
    }

    public void notifyTransportStreamListeners(TransportStreamChangeEvent event) {
        Vector listeners = this.getListeners(transportStreamListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            TransportStreamChangeListener listener = (TransportStreamChangeListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    private Vector getListeners(Hashtable listenerTable) {
        String key = Integer.toString(this.transportID);
        Vector listeners = (Vector)listenerTable.get(key);
        if (listeners == null) {
            listeners = new Vector();
            listenerTable.put(key, listeners);
        }
        return listeners;
    }

    private void notifyAsyncListener(SIChangeEvent event, SIChangeListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifySIChangeThread thread = new NotifySIChangeThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }
}

