/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import com.sun.tv.media.SystemTimeBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.media.IncompatibleSourceException;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.URLDataSource;

public final class Manager {
    private static SystemTimeBase sysTimeBase = null;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static Vector protocolPrefixList = null;
    private static Vector contentPrefixList = null;
    private static Properties jmfProperties = null;
    private static String propFileName = null;
    private static String cacheDirectory = null;

    private Manager() {
    }

    public static Player createPlayer(URL sourceURL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(sourceURL));
    }

    public static Player createPlayer(MediaLocator sourceLocator) throws IOException, NoPlayerException {
        Player newPlayer = null;
        try {
            newPlayer = Manager.createPlayer(sourceLocator, false);
        }
        catch (NoPlayerException e) {
            newPlayer = Manager.createPlayer(sourceLocator, true);
        }
        return newPlayer;
    }

    public static Player createPlayer(DataSource source) throws IOException, NoPlayerException {
        Player newPlayer;
        try {
            newPlayer = Manager.createPlayer(source, source.getContentType());
        }
        catch (NoPlayerException e) {
            newPlayer = Manager.createPlayer(source, UNKNOWN_CONTENT_NAME);
        }
        return newPlayer;
    }

    public static DataSource createDataSource(URL sourceURL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(sourceURL));
    }

    public static DataSource createDataSource(MediaLocator sourceLocator) throws IOException, NoDataSourceException {
        DataSource source = null;
        String protocol = sourceLocator.getProtocol();
        if (protocol.equals("")) {
            throw new NoDataSourceException();
        }
        Enumeration protoList = Manager.getDataSourceList(protocol).elements();
        while (protoList.hasMoreElements()) {
            String protoClassName = (String)protoList.nextElement();
            try {
                Class<?> protoClass = Class.forName(protoClassName);
                source = (DataSource)protoClass.newInstance();
                source.setLocator(sourceLocator);
                source.connect();
                break;
            }
            catch (ClassNotFoundException e) {
                source = null;
            }
            catch (InstantiationException e) {
                source = null;
            }
            catch (IllegalAccessException e) {
                source = null;
            }
        }
        if (source == null) {
            try {
                source = new URLDataSource(sourceLocator.getURL());
                source.connect();
            }
            catch (MalformedURLException me) {
                source = null;
            }
        }
        if (source == null) {
            throw new NoDataSourceException();
        }
        return source;
    }

    public static TimeBase getSystemTimeBase() {
        if (sysTimeBase == null) {
            sysTimeBase = new SystemTimeBase();
        }
        return sysTimeBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Player createPlayer(MediaLocator sourceLocator, boolean useUnknownContent) throws IOException, NoPlayerException {
        Player newPlayer = null;
        String protocol = sourceLocator.getProtocol();
        if (protocol.equals("")) {
            throw new NoPlayerException();
        }
        Enumeration protoList = Manager.getDataSourceList(protocol).elements();
        while (protoList.hasMoreElements()) {
            String protoClassName = (String)protoList.nextElement();
            DataSource source = null;
            try {
                Class<?> protoClass = Class.forName(protoClassName);
                source = (DataSource)protoClass.newInstance();
                source.setLocator(sourceLocator);
                source.connect();
                try {
                    if (useUnknownContent) {
                        newPlayer = Manager.createPlayer(source, UNKNOWN_CONTENT_NAME);
                        break;
                    }
                    newPlayer = Manager.createPlayer(source, source.getContentType());
                    break;
                }
                catch (NoPlayerException e) {
                    newPlayer = null;
                    source.disconnect();
                }
            }
            catch (ClassNotFoundException e) {
                source = null;
            }
            catch (InstantiationException e) {
                source = null;
            }
            catch (IllegalAccessException e) {
                source = null;
            }
        }
        URLDataSource source = null;
        if (newPlayer == null) {
            try {
                source = new URLDataSource(sourceLocator.getURL());
                ((DataSource)source).connect();
                newPlayer = useUnknownContent ? Manager.createPlayer(source, UNKNOWN_CONTENT_NAME) : Manager.createPlayer(source, ((DataSource)source).getContentType());
            }
            catch (MalformedURLException me) {
                source = null;
            }
            finally {
                if (newPlayer == null && source != null) {
                    ((DataSource)source).disconnect();
                }
            }
        }
        if (newPlayer == null) {
            throw new NoPlayerException();
        }
        return newPlayer;
    }

    static Player createPlayer(DataSource source, String contentTypeName) throws IOException, NoPlayerException {
        Player newPlayer = null;
        Enumeration playerList = Manager.getHandlerClassList(contentTypeName).elements();
        DataSource newSource = null;
        while (playerList.hasMoreElements()) {
            String handlerClassName = (String)playerList.nextElement();
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                MediaHandler mHandler = (MediaHandler)handlerClass.newInstance();
                mHandler.setSource(source);
                if (mHandler instanceof Player) {
                    newPlayer = (Player)mHandler;
                    break;
                }
                MediaProxy mProxy = (MediaProxy)mHandler;
                newSource = mProxy.getDataSource();
                String newContentType = newSource.getContentType();
                newPlayer = Manager.createPlayer(newSource, newContentType);
                break;
            }
            catch (ClassNotFoundException e) {
                newPlayer = null;
            }
            catch (InstantiationException e) {
                newPlayer = null;
            }
            catch (IllegalAccessException e) {
                newPlayer = null;
            }
            catch (IncompatibleSourceException e) {
                newPlayer = null;
            }
            catch (NoDataSourceException e) {
                newPlayer = null;
            }
        }
        if (newPlayer == null) {
            throw new NoPlayerException();
        }
        return newPlayer;
    }

    public static Vector getDataSourceList(String protocolName) {
        String sourceName = "media.protocol." + protocolName + ".DataSource";
        return Manager.buildClassList(Manager.getProtocolPrefixList(), sourceName);
    }

    public static Vector getHandlerClassList(String contentName) {
        String handlerName = "media.content." + contentName + ".Handler";
        return Manager.buildClassList(Manager.getContentPrefixList(), handlerName);
    }

    static Vector buildClassList(Vector prefixList, String name) {
        Vector<String> classList = new Vector<String>();
        classList.addElement(name);
        Enumeration prefix = prefixList.elements();
        while (prefix.hasMoreElements()) {
            String prefixName = (String)prefix.nextElement();
            classList.addElement(prefixName + "." + name);
        }
        return classList;
    }

    static Vector getContentPrefixList() {
        return (Vector)PackageManager.getContentPrefixList().clone();
    }

    static Vector getProtocolPrefixList() {
        return (Vector)PackageManager.getProtocolPrefixList().clone();
    }

    static Vector getPersistentProtocolPrefixList() {
        return protocolPrefixList;
    }

    static boolean setPersistentProtocolPrefixList(Vector list) {
        if (list == null) {
            return false;
        }
        protocolPrefixList = list;
        ((Hashtable)jmfProperties).put("protocol.prefixes", Manager.listToString(list));
        return Manager.writeProperties();
    }

    static Vector getPersistentContentPrefixList() {
        return contentPrefixList;
    }

    static boolean setPersistentContentPrefixList(Vector list) {
        if (list == null) {
            return false;
        }
        contentPrefixList = list;
        ((Hashtable)jmfProperties).put("content.prefixes", Manager.listToString(list));
        return Manager.writeProperties();
    }

    static String getPropertiesFileName() {
        if (propFileName == null) {
            String javaHome;
            try {
                javaHome = System.getProperty("java.home");
            }
            catch (Exception e) {
                return null;
            }
            propFileName = javaHome + File.separator + "lib" + File.separator + "jmf.properties";
        }
        return propFileName;
    }

    private static boolean writeProperties() {
        String propFile = Manager.getPropertiesFileName();
        if (propFile == null) {
            return false;
        }
        try {
            System.err.println("File name = " + propFile);
            FileOutputStream out = new FileOutputStream(propFile);
            BufferedOutputStream bs = new BufferedOutputStream(out);
            jmfProperties.save(bs, "JMF Properties");
            bs.flush();
            out.close();
            System.err.println("Wrote properties file");
        }
        catch (Exception e) {
            System.err.println("Error writing properties: " + e);
            return false;
        }
        return true;
    }

    static boolean readProperties() {
        String propFile = Manager.getPropertiesFileName();
        jmfProperties = new Properties();
        if (propFile == null) {
            return false;
        }
        try {
            FileInputStream in = new FileInputStream(propFile);
            jmfProperties.load(new BufferedInputStream(in));
            contentPrefixList = Manager.stringToList(jmfProperties.getProperty("content.prefixes", "java sun"));
            protocolPrefixList = Manager.stringToList(jmfProperties.getProperty("protocol.prefixes", "java sun"));
            cacheDirectory = jmfProperties.getProperty("cache.directory", "");
            in.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static String listToString(Vector list) {
        String s = "";
        for (int i = 0; i < list.size(); ++i) {
            s = s + (String)list.elementAt(i) + " ";
        }
        return s;
    }

    static Vector stringToList(String s) {
        Vector<String> v = new Vector<String>();
        if (s == null) {
            return v;
        }
        s = s + " ";
        while (s.length() > 0) {
            int spc = s.indexOf(" ");
            if (spc > 0) {
                String pkg = s.substring(0, spc);
                v.addElement(pkg);
            }
            if (spc == -1) continue;
            if (s.length() == spc + 1) {
                s = "";
                continue;
            }
            s = s.substring(spc + 1);
        }
        return v;
    }
}

