/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import com.sun.tv.media.util.JMFProperties;
import java.util.Enumeration;
import java.util.Vector;

public class PackageManager {
    static Vector protoPrefixList = PackageManager.getPersistentProtocolPrefixList();
    static Vector contentPrefixList = PackageManager.getPersistentContentPrefixList();

    public static Vector getProtocolPrefixList() {
        SecurityManager security = System.getSecurityManager();
        return protoPrefixList;
    }

    public static void setProtocolPrefixList(Vector list) {
        protoPrefixList = (Vector)list.clone();
    }

    public static void commitProtocolPrefixList() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        PackageManager.setPersistentProtocolPrefixList(protoPrefixList);
    }

    public static Vector getContentPrefixList() {
        SecurityManager security = System.getSecurityManager();
        return contentPrefixList;
    }

    public static void setContentPrefixList(Vector list) {
        contentPrefixList = (Vector)list.clone();
    }

    public static void commitContentPrefixList() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        PackageManager.setPersistentContentPrefixList(contentPrefixList);
    }

    private static void setPersistentProtocolPrefixList(Vector protoList) {
        JMFProperties.setProperty("protocol.prefixes", PackageManager.list2str(protoList));
        JMFProperties.writeProperties();
    }

    private static Vector getPersistentProtocolPrefixList() {
        return PackageManager.str2list(JMFProperties.getProperty("protocol.prefixes"));
    }

    private static void setPersistentContentPrefixList(Vector contentList) {
        JMFProperties.setProperty("content.prefixes", PackageManager.list2str(contentList));
        JMFProperties.writeProperties();
    }

    private static Vector getPersistentContentPrefixList() {
        return PackageManager.str2list(JMFProperties.getProperty("content.prefixes"));
    }

    private static String list2str(Vector list) {
        Enumeration elist = list.elements();
        String value = null;
        while (elist.hasMoreElements()) {
            String name = (String)elist.nextElement();
            if (value == null) {
                value = new String(name);
                continue;
            }
            value = value + "|" + name;
        }
        return value;
    }

    private static Vector str2list(String str) {
        Vector<String> list = new Vector<String>();
        if (str == null) {
            return list;
        }
        int i = 0;
        while ((i = str.indexOf("|")) != -1) {
            list.addElement(str.substring(0, i));
            str = str.substring(i + 1);
        }
        list.addElement(str);
        return list;
    }
}

