/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.graphics;

import java.awt.Color;

public class AlphaColor
extends Color {
    int alphaColorValue;
    boolean isAlphaSupported = false;

    public AlphaColor(float r, float g, float b, float a) {
        super(r, g, b);
        this.testColorValue(r, g, b, a);
        if (!this.isAlphaSupported) {
            a = 1.0f;
        }
        this.alphaColorValue = ((int)(a * 255.0f) & 0xFF) << 24 | ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public AlphaColor(int r, int g, int b, int a) {
        super(r, g, b);
        this.testColorValue(r, g, b, a);
        if (!this.isAlphaSupported) {
            a = 255;
        }
        this.alphaColorValue = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public AlphaColor(int argb, boolean hasAlpha) {
        super(argb);
        this.alphaColorValue = !hasAlpha || !this.isAlphaSupported ? 0xFF000000 | argb : argb;
    }

    public AlphaColor(Color c) {
        super(c.getRGB());
        this.alphaColorValue = !this.isAlphaSupported ? 0xFF000000 | c.getRGB() : c.getRGB();
    }

    public Color brighter() {
        return super.brighter();
    }

    public Color darker() {
        return super.darker();
    }

    public boolean equals(Object obj) {
        return obj instanceof AlphaColor && ((AlphaColor)obj).getRGB() == this.getRGB();
    }

    public int hashCode() {
        return this.alphaColorValue;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.alphaColorValue;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ",a=" + this.getAlpha() + "]";
    }

    private void testColorValue(int r, int g, int b, int a) {
        String errorComponent = "";
        if (r < 0 || r > 255) {
            errorComponent = errorComponent + " Red";
        }
        if (g < 0 || g > 255) {
            errorComponent = errorComponent + " Green";
        }
        if (b < 0 || b > 255) {
            errorComponent = errorComponent + " Blue";
        }
        if (a < 0 || a > 255) {
            errorComponent = errorComponent + " Alpha";
        }
        if (errorComponent.length() > 0) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + errorComponent);
        }
    }

    private void testColorValue(float r, float g, float b, float a) {
        String errorComponent = "";
        if (r < 0.0f || r > 1.0f) {
            errorComponent = errorComponent + " Red";
        }
        if (g < 0.0f || g > 1.0f) {
            errorComponent = errorComponent + " Green";
        }
        if (b < 0.0f || b > 1.0f) {
            errorComponent = errorComponent + " Blue";
        }
        if (a < 0.0f || a > 1.0f) {
            errorComponent = errorComponent + " Alpha";
        }
        if (errorComponent.length() > 0) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + errorComponent);
        }
    }
}

