/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.media;

import java.awt.Rectangle;

public class AWTVideoSize {
    private Rectangle source;
    private Rectangle dest;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public AWTVideoSize(Rectangle source, Rectangle dest) {
        if (source == null || dest == null) {
            throw new NullPointerException("null rectangle");
        }
        this.source = new Rectangle(source);
        this.dest = new Rectangle(dest);
        this.scaleX = this.getXScale();
        this.scaleY = this.getYScale();
    }

    public Rectangle getSource() {
        return new Rectangle(this.source);
    }

    public Rectangle getDestination() {
        return new Rectangle(this.dest);
    }

    public float getXScale() {
        return (float)this.getDestination().width / (float)this.getSource().width;
    }

    public float getYScale() {
        return (float)this.getDestination().height / (float)this.getSource().height;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AWTVideoSize)) {
            return false;
        }
        AWTVideoSize vs1 = this;
        AWTVideoSize vs2 = (AWTVideoSize)other;
        if (!vs1.getDestination().equals(vs2.getDestination())) {
            return false;
        }
        return vs1.getSource().equals(vs2.getSource());
    }

    public String toString() {
        return "source[x=" + this.source.x + ",y=" + this.source.y + ",width=" + this.source.width + ",height=" + this.source.height + "]" + "dest[x=" + this.dest.x + ",y=" + this.dest.y + ",width=" + this.dest.width + ",height=" + this.dest.height + "]" + "scaleX=" + this.scaleX + ", scaleY=" + this.scaleY;
    }
}

