/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.net;

import com.sun.tv.LocatorImpl;
import com.sun.tv.net.EncapIPStream;
import com.sun.tv.net.InterfaceMapImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;

public class InterfaceMap {
    private static int fourthNumber = 0;
    private static int thirdNumber = 1;

    private InterfaceMap() {
    }

    public static InetAddress getLocalAddress(Locator locator) throws InvalidLocatorException, IOException {
        if (locator == null) {
            throw new NullPointerException();
        }
        if (locator.toExternalForm() == null) {
            throw new NullPointerException();
        }
        if (!LocatorImpl.isServiceComponent(locator)) {
            throw new InvalidLocatorException(locator, "Not a ServiceComponent locator");
        }
        if (!EncapIPStream.isIPStreamLocator(locator)) {
            throw new InvalidLocatorException(locator, "Not a source of IP data");
        }
        Hashtable addrUsed = InterfaceMapImpl.addrUsed;
        InetAddress addr = (InetAddress)addrUsed.get(locator.toExternalForm());
        if (addr == null && (addr = InterfaceMap.getNextIP()) != null) {
            addrUsed.put(locator.toExternalForm(), addr);
        }
        if (addr == null) {
            throw new IOException("Can't get the next local IP address");
        }
        return addr;
    }

    private static InetAddress getNextIP() {
        InetAddress addr = null;
        Vector addrFree = InterfaceMapImpl.addrFree;
        if (addrFree.size() > 0) {
            addr = (InetAddress)addrFree.elementAt(0);
            addrFree.removeElementAt(0);
            return addr;
        }
        if (++fourthNumber >= 255) {
            fourthNumber = 1;
            if (++thirdNumber > 255) {
                fourthNumber = 1;
                thirdNumber = 1;
            }
        }
        String ip = "192.168." + thirdNumber + "." + fourthNumber;
        try {
            addr = InetAddress.getByName(ip);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addr;
    }
}

