/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.selection;

import java.io.Serializable;
import java.security.Permission;
import javax.tv.locator.Locator;

public final class SelectPermission
extends Permission
implements Serializable {
    private String actions;

    public SelectPermission(Locator locator, String actions) {
        super(locator == null ? "*" : locator.toExternalForm());
        this.actions = actions;
        if (actions == null) {
            throw new NullPointerException();
        }
    }

    public SelectPermission(String locator, String actions) {
        super(locator == null ? "*" : locator);
        this.actions = actions;
        if (actions == null) {
            throw new NullPointerException();
        }
    }

    public boolean implies(Permission p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (!(p instanceof SelectPermission)) {
            return false;
        }
        SelectPermission sp = (SelectPermission)p;
        boolean isName = this.getName().equals(sp.getName()) || this.getName().equals("*");
        boolean isAction = this.getActions().equals(sp.getActions()) || this.getActions().equals("*");
        return isName && isAction;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SelectPermission)) {
            return false;
        }
        SelectPermission that = (SelectPermission)other;
        return this.getName().equals(that.getName()) && this.getActions().equals(that.getActions());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.actions.hashCode();
    }

    public String getActions() {
        return this.actions;
    }
}

