/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hex;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Random;

public abstract class Aes {
    public static final int KEY_SIZE = 128;
    public static final int KEY_SIZE_IN_BYTES = 16;
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_SIZE_IN_BYTES = 16;

    protected static final byte[] newIv(Random random) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    public static final byte[] newIv() {
        return Aes.newIv(new SecureRandom());
    }

    public abstract byte[] encrypt(byte[] var1, byte[] var2);

    public byte[] encrypt(byte[] iv, String decrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted");
        }
        try {
            return this.encrypt(iv, decrypted.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?", uee);
        }
    }

    public String encryptToString(byte[] iv, byte[] decrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted");
        }
        return Hex.encodeToString(this.encrypt(iv, decrypted));
    }

    public String encryptToString(byte[] iv, String decrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted");
        }
        try {
            return this.encryptToString(iv, decrypted.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?", uee);
        }
    }

    public abstract byte[] decrypt(byte[] var1, byte[] var2);

    public byte[] decrypt(byte[] iv, String encrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted");
        }
        return this.decrypt(iv, Hex.decode(encrypted));
    }

    public String decryptToString(byte[] iv, byte[] encrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted");
        }
        try {
            return new String(this.decrypt(iv, encrypted), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?", uee);
        }
    }

    public String decryptToString(byte[] iv, String encrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted");
        }
        return this.decryptToString(iv, Hex.decode(encrypted));
    }
}

