/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.cli;

import com.googlecode.jsonschema2pojo.Annotator;
import com.googlecode.jsonschema2pojo.AnnotatorFactory;
import com.googlecode.jsonschema2pojo.GenerationConfig;
import com.googlecode.jsonschema2pojo.SchemaGenerator;
import com.googlecode.jsonschema2pojo.SchemaMapper;
import com.googlecode.jsonschema2pojo.SchemaStore;
import com.googlecode.jsonschema2pojo.cli.Arguments;
import com.googlecode.jsonschema2pojo.exception.GenerationException;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class Jsonschema2Pojo {
    private Jsonschema2Pojo() {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Arguments arguments = new Arguments().parse(args);
        Jsonschema2Pojo.generate(arguments);
    }

    public static void generate(GenerationConfig config) throws FileNotFoundException, IOException {
        Annotator annotator = new AnnotatorFactory().getAnnotator(config.getAnnotationStyle());
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, annotator, new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        Iterator sources = config.getSource();
        while (sources.hasNext()) {
            File source = (File)sources.next();
            if (source.isDirectory()) {
                List<File> schemaFiles = Arrays.asList(source.listFiles());
                Collections.sort(schemaFiles);
                for (File child : schemaFiles) {
                    if (!child.isFile()) continue;
                    mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(child), StringUtils.defaultString((String)config.getTargetPackage()), child.toURI().toURL());
                }
                continue;
            }
            mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(source), StringUtils.defaultString((String)config.getTargetPackage()), source.toURI().toURL());
        }
        if (!config.getTargetDirectory().exists() && !config.getTargetDirectory().mkdirs()) {
            throw new GenerationException("Could not create or access target directory " + config.getTargetDirectory().getAbsolutePath());
        }
        codeModel.build(config.getTargetDirectory());
    }

    private static String getNodeName(File file) {
        return StringUtils.substringBeforeLast((String)file.getName(), (String)".");
    }
}

