/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.maven;

import com.googlecode.jsonschema2pojo.AnnotationStyle;
import com.googlecode.jsonschema2pojo.GenerationConfig;
import com.googlecode.jsonschema2pojo.SourceType;
import com.googlecode.jsonschema2pojo.cli.Jsonschema2Pojo;
import com.googlecode.jsonschema2pojo.maven.ProjectClasspath;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Jsonschema2PojoMojo
extends AbstractMojo
implements GenerationConfig {
    private File outputDirectory;
    private File sourceDirectory;
    private File[] sourcePaths;
    private String targetPackage = "";
    private boolean generateBuilders = false;
    private boolean usePrimitives = false;
    private boolean addCompileSourceRoot = true;
    private boolean skip = false;
    private String propertyWordDelimiters = "";
    private boolean useLongIntegers = false;
    private boolean includeHashcodeAndEquals = true;
    private boolean includeToString = true;
    private String annotationStyle = "jackson";
    private boolean includeJsr303Annotations = false;
    private String sourceType = "jsonschema";
    private MavenProject project;

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Private fields set by Maven.")
    public void execute() throws MojoExecutionException {
        try {
            AnnotationStyle.valueOf((String)StringUtils.upperCase((String)this.annotationStyle));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Not a valid annotation style: " + this.annotationStyle);
        }
        if (this.skip) {
            return;
        }
        if (null == this.sourceDirectory && null == this.sourcePaths) {
            throw new MojoExecutionException("One of sourceDirectory or sourcePaths must be provided");
        }
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        }
        this.addProjectDependenciesToClasspath();
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating classes from JSON Schema file(s) " + this.sourceDirectory.getPath(), (Exception)e);
        }
    }

    private void addProjectDependenciesToClasspath() {
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = new ProjectClasspath().getClassLoader(this.project, oldClassLoader, this.getLog());
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().info((CharSequence)"Skipping addition of project artifacts, there appears to be a dependecy resolution problem", (Throwable)e);
        }
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public File getTargetDirectory() {
        return this.outputDirectory;
    }

    public Iterator<File> getSource() {
        if (null != this.sourceDirectory) {
            return Collections.singleton(this.sourceDirectory).iterator();
        }
        return Arrays.asList(this.sourcePaths).iterator();
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return this.propertyWordDelimiters.toCharArray();
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public AnnotationStyle getAnnotationStyle() {
        return AnnotationStyle.valueOf((String)this.annotationStyle.toUpperCase());
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public SourceType getSourceType() {
        return SourceType.valueOf((String)this.sourceType.toUpperCase());
    }
}

