/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t;

import com.googlecode.jweb1t.FolderScanner;
import com.googlecode.jweb1t.IndexFilter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class AggregatedCountsCreator {
    private long aggregatedNGramCount = 0L;
    private long nrOfDifferentNGrams = 0L;

    public AggregatedCountsCreator(File aBaseDir, String aNGramSize) throws IOException {
        File ngramFile = new File(aBaseDir + "/" + aNGramSize + "gms/");
        if (ngramFile.isFile()) {
            this.read(ngramFile);
        } else {
            FolderScanner scanner = new FolderScanner(ngramFile);
            scanner.setFilter(new IndexFilter());
            while (scanner.hasNext()) {
                for (File file : scanner.next()) {
                    this.read(file);
                }
            }
        }
    }

    private void read(File aFile) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new FileReader(aFile));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts.length != 2) continue;
            ++this.nrOfDifferentNGrams;
            this.aggregatedNGramCount += Long.valueOf(parts[1]).longValue();
        }
        reader.close();
    }

    public long getAggregatedNGramCount() {
        return this.aggregatedNGramCount;
    }

    public long getNrOfDifferentNGrams() {
        return this.nrOfDifferentNGrams;
    }
}

