/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSearch {
    private int windowSize = 200;
    private final RandomAccessFile raf;
    private final String ENCODING = "UTF-8";
    private final char EOL = (char)10;

    public FileSearch(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
    }

    public void setWindowSize(int aWindowSize) {
        this.windowSize = aWindowSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFreq(String aSymbol) throws IOException {
        long start = 0L;
        long pos = this.raf.length();
        long end = this.raf.length();
        while (end > start + 1L) {
            pos = start + (end - start) / 2L;
            String[] ngram = this.read(pos);
            if (ngram == null) {
                return 0L;
            }
            int c = aSymbol.compareTo(ngram[0]);
            if (c == 0) {
                return Long.parseLong(ngram[1]);
            }
            if (c > 0) {
                start = pos;
                continue;
            }
            end = pos;
        }
        return 0L;
    }

    public String[] read(long pos) throws IOException {
        int i;
        long end;
        long start = pos - (long)this.windowSize;
        if (start < 0L) {
            start = 0L;
        }
        if ((end = pos + (long)this.windowSize) > this.raf.length()) {
            end = this.raf.length();
        }
        int len = (int)(end - start);
        int newPos = (int)(pos - start);
        this.raf.seek(start);
        byte[] window = new byte[len];
        this.raf.read(window);
        for (i = newPos; i >= 0 && (char)window[i] != '\n'; --i) {
        }
        int newStart = i + 1;
        for (i = newPos + 1; i < window.length && (char)window[i] != '\n'; ++i) {
        }
        int newEnd = i;
        byte[] curLine = new byte[newEnd - newStart];
        int index = 0;
        for (int j = newStart; j < newEnd; ++j) {
            curLine[index++] = window[j];
        }
        String lineAsString = new String(curLine, "UTF-8");
        if (lineAsString.length() == 0) {
            return null;
        }
        String[] ngram = new String[2];
        int tabOffset = lineAsString.indexOf(9);
        if (tabOffset != -1) {
            ngram[0] = lineAsString.substring(0, tabOffset);
            ngram[1] = lineAsString.substring(tabOffset + 1, lineAsString.length());
            return ngram;
        }
        return null;
    }
}

