/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t;

import com.googlecode.jweb1t.FolderScanner;
import com.googlecode.jweb1t.IndexFilter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexCreator {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, List<File>> map = new HashMap<String, List<File>>();
    private final File baseDir;

    public IndexCreator(File aBaseDir, String aNGramSize) throws IOException {
        this.baseDir = aBaseDir;
        File ngramFile = new File(aBaseDir + "/" + aNGramSize + "gms/");
        File indexFile = new File(aBaseDir + "/" + "index-" + aNGramSize + "gms");
        if (ngramFile.isFile()) {
            this.read(ngramFile);
        } else {
            FolderScanner scanner = new FolderScanner(ngramFile);
            scanner.setFilter(new IndexFilter());
            int count = 0;
            while (scanner.hasNext()) {
                File[] files = scanner.next();
                this.logger.info((Object)(count++ + " : " + files.length));
                for (int i = 0; i < files.length; ++i) {
                    long begin = System.currentTimeMillis();
                    this.read(files[i]);
                    long end = System.currentTimeMillis();
                    this.logger.info((Object)(count + ", " + files[i] + " read in " + (end - begin) + " ms"));
                    ++count;
                }
            }
        }
        this.write(indexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File outputFile) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(outputFile));
            for (String ch : this.map.keySet()) {
                List<File> fileList = this.map.get(ch);
                writer.print(ch);
                for (File file : fileList) {
                    String relative = this.baseDir.toURI().relativize(file.toURI()).getPath();
                    writer.print("\t" + relative);
                }
                writer.print("\n");
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(File aFile) throws IOException {
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(aFile));
            String line = null;
            String ch = null;
            line = reader.readLine();
            if (line != null) {
                ch = line.substring(0, 2).trim();
            }
            String old = ch;
            while ((line = reader.readLine()) != null) {
                ch = line.substring(0, 2).trim();
                if (ch.equals(old)) continue;
                this.put(old, aFile);
                old = ch;
            }
            this.put(old, aFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    private void put(String ch, File aFile) {
        List<File> fileList = this.map.get(ch);
        if (fileList == null) {
            fileList = new ArrayList<File>();
            fileList.add(aFile);
            this.map.put(ch, fileList);
            return;
        }
        fileList.add(aFile);
    }
}

