/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t;

import com.googlecode.jweb1t.FolderScanner;
import com.googlecode.jweb1t.IndexFilter;
import com.googlecode.jweb1t.util.NGramIterator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class JWeb1TIterator {
    private final String ngramLocation;
    private final int ngramSize;

    public JWeb1TIterator(String aNGramLocation, int aNGramSize) throws IOException {
        this.ngramLocation = aNGramLocation;
        this.ngramSize = aNGramSize;
    }

    public NGramIterator getIterator() throws IOException {
        File ngramFile = new File(this.ngramLocation + "/" + this.ngramSize + "gms/");
        LinkedList<File> ngramFiles = new LinkedList<File>();
        if (ngramFile.isFile()) {
            ngramFiles.add(ngramFile);
        } else {
            FolderScanner scanner = new FolderScanner(ngramFile);
            scanner.setFilter(new IndexFilter());
            while (scanner.hasNext()) {
                for (File file : scanner.next()) {
                    ngramFiles.add(file);
                }
            }
        }
        return new NGramIterator(ngramFiles);
    }
}

