/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t;

import com.googlecode.jweb1t.FileMap;
import com.googlecode.jweb1t.FileSearch;
import com.googlecode.jweb1t.Searcher;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWeb1TSearcher
implements Searcher {
    private static final Log LOG = LogFactory.getLog(JWeb1TSearcher.class);
    private Map<Integer, FileMap> indexMap;
    private Map<Integer, Long> ngramCountMap;
    private Map<Integer, Long> ngramDistinctCountMap;

    public JWeb1TSearcher(String ... indexFiles) throws IOException {
        if (indexFiles.length > 0) {
            this.initialize(new File(indexFiles[0]).getParentFile());
        }
        for (int i = 1; i <= indexFiles.length; ++i) {
            this.addToIndexMap(new File(indexFiles[i - 1]), i);
        }
    }

    public JWeb1TSearcher(File indexPath, int minN, int maxN) throws IOException {
        this.initialize(indexPath);
        if (minN < 0 || maxN < 0 || minN > maxN) {
            throw new IOException("Wrong parameters.");
        }
        for (int i = minN; i <= maxN; ++i) {
            this.addToIndexMap(new File(indexPath, "index-" + i + "gms"), i);
        }
    }

    private void initialize(File baseDir) throws NumberFormatException, IOException {
        this.indexMap = new HashMap<Integer, FileMap>();
        this.ngramCountMap = new HashMap<Integer, Long>();
        this.ngramDistinctCountMap = new HashMap<Integer, Long>();
        File countFile = new File(baseDir, "aggregated_counts.cnt");
        if (countFile.exists()) {
            String line;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(countFile));
            while ((line = lineReader.readLine()) != null) {
                String[] parts = line.split("\t");
                if (parts.length != 3) continue;
                int ngramSize = Integer.valueOf(parts[0]);
                long ngramDistinctCount = Long.valueOf(parts[1]);
                long ngramCount = Long.valueOf(parts[2]);
                this.ngramCountMap.put(ngramSize, ngramCount);
                this.ngramDistinctCountMap.put(ngramSize, ngramDistinctCount);
            }
            lineReader.close();
        }
    }

    private void addToIndexMap(File indexFile, int level) throws IOException {
        if (!indexFile.exists()) {
            throw new IOException("Index file " + indexFile.getPath() + " was not found");
        }
        this.indexMap.put(level, new FileMap(indexFile));
    }

    @Override
    public long getFrequency(Collection<String> aPhrase) throws IOException {
        return this.getFrequency(StringUtils.join(aPhrase, (String)" "));
    }

    @Override
    public long getFrequency(String ... aPhrase) throws IOException {
        int i;
        FileMap map;
        if (aPhrase == null || aPhrase.length == 0) {
            return 0L;
        }
        String phrase = StringUtils.join((Object[])aPhrase, (String)" ").trim();
        if (phrase.length() == 0) {
            return 0L;
        }
        String[] tokens = phrase.split("\\s+");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("search for : \"" + phrase + "\""));
            LOG.debug((Object)("length: " + tokens.length));
        }
        if ((map = this.indexMap.get(tokens.length)) == null) {
            LOG.fatal((Object)(tokens.length + "-gram index not found"));
            return 0L;
        }
        String symbol = null;
        symbol = tokens[0].length() < 2 ? tokens[0].substring(0, 1) : tokens[0].substring(0, 2);
        String[] file = map.get(symbol);
        if (file == null) {
            LOG.debug((Object)("Could not find nGram-File for the symbol: " + symbol));
            return -1L;
        }
        StringBuilder ngram = new StringBuilder();
        for (i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                ngram.append(' ');
            }
            ngram.append(tokens[i]);
        }
        for (i = 0; i < file.length; ++i) {
            LOG.debug((Object)(i + ":" + file[i]));
            FileSearch fileSearch = new FileSearch(new File(file[i]));
            long frequency = fileSearch.getFreq(ngram.toString());
            if (frequency != 0L) {
                fileSearch.close();
                LOG.debug((Object)("Frequency: " + frequency));
                return frequency;
            }
            fileSearch.close();
        }
        LOG.debug((Object)"Frequency: 0");
        return 0L;
    }

    @Override
    public long getNrOfNgrams(int aNGramSize) {
        Long count = this.ngramCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }

    @Override
    public long getNrOfDistinctNgrams(int aNGramSize) {
        Long count = this.ngramDistinctCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }
}

