/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jweb1t.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGramIterator
implements Iterator<String> {
    private Queue<File> ngramFiles;
    private LineNumberReader reader;
    private String storedNextString;

    public NGramIterator(Queue<File> ngramFiles) throws IOException {
        this.ngramFiles = ngramFiles;
        if (ngramFiles.size() <= 0) {
            throw new IOException("Filelist is empty.");
        }
        this.reader = new LineNumberReader(new FileReader(ngramFiles.poll()));
    }

    @Override
    public boolean hasNext() {
        this.storedNextString = this.getNextString();
        return this.storedNextString != null;
    }

    @Override
    public String next() {
        if (this.storedNextString == null) {
            return this.getNextString();
        }
        String returnValue = this.storedNextString;
        this.storedNextString = null;
        return returnValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String getNextString() {
        String nextString = null;
        if (this.storedNextString != null) {
            return this.storedNextString;
        }
        try {
            String line = this.reader.readLine();
            if (line != null) {
                String[] parts = line.split("\t");
                if (parts.length > 0) {
                    nextString = parts[0];
                }
            } else {
                this.reader.close();
                if (!this.ngramFiles.isEmpty()) {
                    this.reader = new LineNumberReader(new FileReader(this.ngramFiles.poll()));
                    nextString = this.getNextString();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nextString;
    }
}

