/*
 * Decompiled with CFR 0.152.
 */
package kiama.parsing;

import java.io.Reader;
import java.rmi.RemoteException;
import junit.framework.Assert;
import junit.framework.TestCase;
import kiama.example.imperative.AST;
import kiama.example.imperative.Generator$class;
import kiama.example.imperative.Parser$class;
import kiama.example.imperative.PrettyPrinter$class;
import kiama.example.imperative.TestBase;
import kiama.parsing.CharPackratParsers;
import kiama.parsing.CharParsers;
import kiama.parsing.CharParsers$class;
import kiama.parsing.PackratParsers;
import kiama.parsing.PackratParsers$Head$;
import kiama.parsing.PackratParsers$LR$;
import kiama.parsing.PackratParsers$Result$;
import kiama.parsing.PackratParsers$class;
import kiama.parsing.PackratParsersTests$;
import kiama.parsing.Parsers;
import kiama.parsing.Parsers$$tilde$;
import kiama.parsing.Parsers$Failure$;
import kiama.parsing.Parsers$Success$;
import kiama.parsing.Parsers$class;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Prop;
import org.scalacheck.Shrink;
import org.scalacheck.Shrink$;
import org.scalacheck.Test;
import org.scalatest.Assertions;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.junit.JUnit3Suite;
import org.scalatest.prop.Checkers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.Manifest;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random;
import scala.util.matching.Regex;
import scala.util.parsing.input.CharSequenceReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PackratParsersTests
extends TestCase
implements JUnit3Suite,
Checkers,
CharPackratParsers,
TestBase,
ScalaObject {
    private /* synthetic */ Parsers$$tilde$ $tilde$module;
    private /* synthetic */ Parsers$Failure$ Failure$module;
    private /* synthetic */ Parsers$Success$ Success$module;
    private /* synthetic */ PackratParsers$LR$ LR$module;
    private /* synthetic */ PackratParsers$Result$ Result$module;
    private /* synthetic */ PackratParsers$Head$ Head$module;
    public volatile int bitmap$1;
    public volatile int bitmap$0;
    private final String org$scalatest$Suite$$IgnoreAnnotation;
    private final String org$scalatest$Suite$$InformerInParens;
    private final String org$scalatest$Suite$$TestMethodPrefix;
    private final Parsers.Parser any;
    private PackratParsers.LR LRStack;
    private HashMap heads;
    private final Parsers.Parser letterOrDigit;
    private final Parsers.Parser letter;
    private final Parsers.Parser digit;
    private final Parsers.Parser layout;
    private final Parsers.Parser whitespace;
    private final Object genLeafStmt;
    private final Gen genLeafExp;
    private final Gen genVar;
    private final Gen genIdn;
    private final Gen genNum;
    private final Gen genDouble;
    private final Gen genInteger;
    private final Parsers.Parser keyword;
    private final Parsers.Parser idn;
    private final Parsers.Parser variable;
    private final Parsers.Parser integer;
    private final Parsers.Parser double;
    private final PackratParsers.MemoParser factor;
    private final PackratParsers.MemoParser term;
    private final PackratParsers.MemoParser exp;
    private final Parsers.Parser sequence;
    private final Parsers.Parser whileStmt;
    private final Parsers.Parser asgnStmt;
    private final Parsers.Parser stmt;
    private final Parsers.Parser parse;
    private final Random random;
    private final CharSequenceReader empty;

    public PackratParsersTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        JUnit3Suite.class.$init$((JUnit3Suite)this);
        Checkers.class.$init$((Checkers)this);
        Parsers$class.$init$(this);
        PackratParsers$class.$init$(this);
        CharParsers$class.$init$(this);
        Generator$class.$init$(this);
        Parser$class.$init$(this);
        PrettyPrinter$class.$init$(this);
        this.empty = this.input("");
        this.random = new Random();
    }

    private final Arbitrary arbIdn$1() {
        return Arbitrary$.MODULE$.apply((Function0)new $anonfun$arbIdn$1$1(this));
    }

    public void testFixedRepetition() {
        this.expect(this.repN(0, new $anonfun$testFixedRepetition$1(this)), "", Nil$.MODULE$);
        Assert.assertTrue((boolean)this.isSuccessWith(this.repN(0, new $anonfun$testFixedRepetition$2(this)).apply((scala.util.parsing.input.Reader<Object>)this.input("[]")), Nil$.MODULE$));
        this.expect(this.repN(3, new $anonfun$testFixedRepetition$3(this)), "56 val 2.3", List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Exp[]{new AST.Num(56.0), new AST.Var("val"), new AST.Num(2.3)})));
        Assert.assertTrue((boolean)this.isSuccessWith(this.repN(2, new $anonfun$testFixedRepetition$4(this)).apply((scala.util.parsing.input.Reader<Object>)this.input("56 val 2.3")), List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Exp[]{new AST.Num(56.0), new AST.Var("val")}))));
    }

    public void testSeparators() {
        Parsers.Parser p = this.repsep(new $anonfun$8(this), new $anonfun$9(this));
        this.expect(p, "", Nil$.MODULE$);
        Assert.assertTrue((boolean)this.isSuccessWith(p.apply((scala.util.parsing.input.Reader<Object>)this.empty()), Nil$.MODULE$));
        Assert.assertTrue((boolean)this.isSuccessWith(p.apply((scala.util.parsing.input.Reader<Object>)this.input(":=")), Nil$.MODULE$));
        this.expect(p, "1, 2", List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Num[]{new AST.Num(1.0), new AST.Num(2.0)})));
        this.expect(p, "v, 67, 12.3", List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Exp[]{new AST.Var("v"), new AST.Num(67.0), new AST.Num(12.3)})));
        Parsers.Parser q2 = this.rep1sep(new $anonfun$10(this), new $anonfun$11(this));
        Assert.assertTrue((boolean)this.isFail(q2.apply((scala.util.parsing.input.Reader<Object>)this.empty())));
        Assert.assertTrue((boolean)this.isFail(q2.apply((scala.util.parsing.input.Reader<Object>)this.input(":="))));
        this.expect(q2, "1,2", List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Num[]{new AST.Num(1.0), new AST.Num(2.0)})));
        this.expect(q2, "v,67,12.3", List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Exp[]{new AST.Var("v"), new AST.Num(67.0), new AST.Num(12.3)})));
    }

    public void testPartialFunction() {
        Parsers.Parser p = this.integer().$up$qmark(new $anonfun$1(this));
        this.expect(p, "123", "122.0");
        Assert.assertTrue((boolean)this.isFail(p.apply((scala.util.parsing.input.Reader<Object>)this.input("hello"))));
        Parsers.Parser q2 = this.exp().$up$qmark(new $anonfun$2(this));
        Assert.assertTrue((boolean)this.isFail(q2.apply((scala.util.parsing.input.Reader<Object>)this.input("123"))));
        Assert.assertTrue((boolean)this.isFail(q2.apply((scala.util.parsing.input.Reader<Object>)this.input("9.0"))));
        Parsers.Parser r = this.idn().$up$qmark(new $anonfun$3(this), new $anonfun$7(this));
        Assert.assertTrue((boolean)this.isSuccessWith(r.apply((scala.util.parsing.input.Reader<Object>)this.input("abc")), "abc has length 3"));
        Assert.assertTrue((boolean)this.isFailWith(r.apply((scala.util.parsing.input.Reader<Object>)this.input("hello")), "hello unexpected"));
    }

    public void testValueSequence() {
        Parsers.Parser number2 = this.token(this.digit().$plus()).$up$up(new $anonfun$5(this));
        Parsers.Parser nntimes2 = number2.$greater$greater(new $anonfun$6(this));
        this.expect(nntimes2, "0 0", "0");
        this.expect(nntimes2, "21 42", "42");
        Assert.assertTrue((boolean)this.isFail(nntimes2.apply((scala.util.parsing.input.Reader<Object>)this.input("4"))));
        Assert.assertTrue((boolean)this.isFail(nntimes2.apply((scala.util.parsing.input.Reader<Object>)this.input("12 99"))));
    }

    public void testRegexes() {
        Parsers.Parser<String> decimal$1 = this.regex(Predef$.MODULE$.stringWrapper("-?\\d+\\.(\\d*)?").r());
        List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"1.", "123.456", "-99.0"})).foreach((Function1)new $anonfun$testRegexes$1(this, decimal$1));
        List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"123", "  123", ".99", "-.001", "harold"})).foreach((Function1)new $anonfun$testRegexes$2(this, decimal$1));
    }

    public void testOptionality() {
        this.check(new $anonfun$testOptionality$1(this), new $anonfun$testOptionality$2(this), this.arbStmt(), Shrink$.MODULE$.shrinkAny());
        this.check(new $anonfun$testOptionality$3(this), new $anonfun$testOptionality$4(this), this.arbExp(), Shrink$.MODULE$.shrinkAny());
    }

    public void testAndPredicate() {
        this.sameResultNoInput(this.integer(), this.arbNum());
        this.sameResultNoInput(this.double(), this.arbNum());
        this.sameResultNoInput(this.asgnStmt(), this.arbAsgn());
        this.sameResultNoInput(this.whileStmt(), this.arbWhile());
        this.sameResultNoInput(this.stmt(), this.arbStmt());
    }

    public <T extends AST.PrettyPrintable> void sameResultNoInput(Parsers.Parser<T> p$1, Arbitrary<T> arbT) {
        this.check(new $anonfun$sameResultNoInput$1(this, p$1), new $anonfun$sameResultNoInput$2(this), arbT, Shrink$.MODULE$.shrinkAny());
    }

    public void testNotPredicate() {
        Assert.assertTrue((boolean)this.notPredSucceeds(this.integer().unary_$bang(), "hello"));
        Assert.assertTrue((boolean)this.notPredFails(this.integer().unary_$bang(), "42"));
        Assert.assertTrue((boolean)this.notPredSucceeds(this.asgnStmt().unary_$bang(), "a = ;"));
        Assert.assertTrue((boolean)this.notPredFails(this.asgnStmt().unary_$bang(), "a = 5;"));
        Assert.assertTrue((boolean)this.notPredSucceeds(this.stmt().unary_$bang(), "while (c + 3) { a = 5; b = ; }"));
        Assert.assertTrue((boolean)this.notPredFails(this.stmt().unary_$bang(), "while (c + 3) { a = 5; b = c; }"));
        this.check(new $anonfun$testNotPredicate$1(this), new $anonfun$testNotPredicate$2(this), this.arbStmt(), Shrink$.MODULE$.shrinkAny());
        this.check(new $anonfun$testNotPredicate$3(this), new $anonfun$testNotPredicate$4(this), this.arbExp(), Shrink$.MODULE$.shrinkAny());
    }

    public <T> boolean notPredFails(Parsers.Parser<T> parser, String str) {
        CharSequenceReader in = this.input(str);
        return this.isFailAt(parser.apply((scala.util.parsing.input.Reader<Object>)in), (scala.util.parsing.input.Reader<Character>)in);
    }

    public <T> boolean notPredSucceeds(Parsers.Parser<T> parser, String str) {
        Parsers.ParseResult<T> parseResult;
        block5: {
            boolean bl;
            block4: {
                block2: {
                    block3: {
                        CharSequenceReader in = this.input(str);
                        parseResult = parser.apply((scala.util.parsing.input.Reader<Object>)in);
                        if (!(parseResult instanceof Parsers.Success)) break block2;
                        Parsers.Success success2 = (Parsers.Success)parseResult;
                        scala.util.parsing.input.Reader<Object> reader = success2.in();
                        if (!(success2.result() instanceof BoxedUnit)) break block3;
                        bl = this.same((scala.util.parsing.input.Reader<Character>)in, reader);
                        break block4;
                    }
                    throw new MatchError(parseResult);
                }
                if (!(parseResult instanceof Parsers.Failure)) break block5;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(parseResult);
    }

    public void testParsePrograms() {
        this.roundtrip(this.parse(), this.arbStmt());
    }

    public void testParseStatements() {
        this.roundtrip(this.stmt(), this.arbStmt());
    }

    public void testParseWhilestmts() {
        this.expect(this.whileStmt(), "while (1) ;", new AST.While(new AST.Num(1.0), new AST.Null()));
        this.expect(this.whileStmt(), "while (a + 3) { a = a - 1; }", new AST.While(new AST.Add(new AST.Var("a"), new AST.Num(3.0)), new AST.Seqn((Seq<AST.Stmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Asgn[]{new AST.Asgn("a", new AST.Sub(new AST.Var("a"), new AST.Num(1.0)))})))));
        this.roundtrip(this.whileStmt(), this.arbWhile());
    }

    public void testParseSequences() {
        this.expect(this.sequence(), "{}", new AST.Seqn((Seq<AST.Stmt>)Nil$.MODULE$));
        this.expect(this.sequence(), "{ ; }", new AST.Seqn((Seq<AST.Stmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Null[]{new AST.Null()}))));
        this.expect(this.sequence(), "{ v = 1; v = 2; }", new AST.Seqn((Seq<AST.Stmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AST.Asgn[]{new AST.Asgn("v", new AST.Num(1.0)), new AST.Asgn("v", new AST.Num(2.0))}))));
        this.roundtrip(this.sequence(), this.arbSeqn());
    }

    public void testParseAssignStmts() {
        this.expect(this.asgnStmt(), "a = 5;", new AST.Asgn("a", new AST.Num(5.0)));
        this.expect(this.asgnStmt(), "a = b;", new AST.Asgn("a", new AST.Var("b")));
        this.roundtrip(this.asgnStmt(), this.arbAsgn());
    }

    public void testParseNullStmt() {
        this.expect(this.stmt(), ";", new AST.Null());
        this.expect(this.stmt(), ";     ", new AST.Null());
    }

    public void testKeywords() {
        Assert.assertTrue((boolean)this.isFail(this.asgnStmt().apply((scala.util.parsing.input.Reader<Object>)this.input("while = 3;"))));
    }

    public void testParseExpressions() {
        this.expect(this.exp(), "1", new AST.Num(1.0));
        this.expect(this.exp(), "1+2", new AST.Add(new AST.Num(1.0), new AST.Num(2.0)));
        this.expect(this.exp(), "1+2*3", new AST.Add(new AST.Num(1.0), new AST.Mul(new AST.Num(2.0), new AST.Num(3.0))));
        this.expect(this.exp(), "(1+2)*3", new AST.Mul(new AST.Add(new AST.Num(1.0), new AST.Num(2.0)), new AST.Num(3.0)));
        this.roundtrip(this.exp(), this.arbExp());
    }

    public void testParseVariables() {
        this.expect(this.variable(), "a", new AST.Var("a"));
        this.expect(this.variable(), "total", new AST.Var("total"));
        this.expect(this.variable(), "sum123", new AST.Var("sum123"));
        this.check(new $anonfun$testParseVariables$1(this), new $anonfun$testParseVariables$2(this), this.arbIdn$1(), Shrink$.MODULE$.shrinkString());
    }

    public void testParseNumbers() {
        this.check(new $anonfun$testParseNumbers$1(this), new $anonfun$testParseNumbers$2(this), Arbitrary$.MODULE$.arbInt(), Shrink$.MODULE$.shrinkInt());
        this.check(new $anonfun$testParseNumbers$3(this), new $anonfun$testParseNumbers$4(this), Arbitrary$.MODULE$.arbDouble(), Shrink$.MODULE$.shrinkAny());
    }

    public void testAny() {
        this.check(new $anonfun$testAny$1(this), new $anonfun$testAny$2(this), Arbitrary$.MODULE$.arbChar(), Shrink$.MODULE$.shrinkAny());
    }

    public void testFirstElementFailure() {
        this.check(new $anonfun$testFirstElementFailure$1(this), new $anonfun$testFirstElementFailure$2(this), this.arbInput(), Shrink$.MODULE$.shrinkAny());
    }

    public void testFirstElementSuccess() {
        this.check(new $anonfun$testFirstElementSuccess$1(this), new $anonfun$testFirstElementSuccess$2(this), this.arbInput(), Shrink$.MODULE$.shrinkAny());
    }

    public void testAnyInputFailure() {
        this.check(new $anonfun$testAnyInputFailure$1(this), new $anonfun$testAnyInputFailure$2(this), this.arbInput(), Shrink$.MODULE$.shrinkAny());
    }

    public void testAnyInputSuccess() {
        this.check(new $anonfun$testAnyInputSuccess$1(this), new $anonfun$testAnyInputSuccess$2(this), this.arbInput(), Shrink$.MODULE$.shrinkAny());
    }

    public void testNoReadFailure() {
        Assert.assertTrue((boolean)this.same(this.failure("fail").apply((scala.util.parsing.input.Reader<Object>)this.empty()), new Parsers.Failure(this, "fail", (scala.util.parsing.input.Reader<Object>)this.empty())));
    }

    public void testNoReadSuccess() {
        Assert.assertTrue((boolean)this.same(this.success("hi").apply((scala.util.parsing.input.Reader<Object>)this.empty()), new Parsers.Success<String>(this, "hi", (scala.util.parsing.input.Reader<Object>)this.empty())));
    }

    public <T extends AST.PrettyPrintable> void roundtrip(Parsers.Parser<T> parser$1, Arbitrary<T> arbT) {
        this.check(new $anonfun$roundtrip$1(this, parser$1), new $anonfun$roundtrip$2(this), arbT, Shrink$.MODULE$.shrinkAny());
    }

    public <T> boolean expectBool(Parsers.Parser<T> parser, String str, T result) {
        boolean bl;
        Parsers.Parser<T> p = parser.$less$tilde(new $anonfun$4(this));
        Parsers.ParseResult<T> parseResult = p.apply((scala.util.parsing.input.Reader<Object>)this.input(str));
        if (parseResult instanceof Parsers.Success) {
            Parsers.Success success2 = (Parsers.Success)parseResult;
            scala.util.parsing.input.Reader<Object> reader = success2.in();
            bl = BoxesRunTime.equals(result, success2.result()) ? reader.atEnd() : false;
        } else {
            bl = false;
        }
        return bl;
    }

    public <T> void expect(Parsers.Parser<T> parser, String str, T result) {
        Parsers.ParseResult<T> parseResult = parser.apply((scala.util.parsing.input.Reader<Object>)this.input(str));
        if (parseResult instanceof Parsers.Success) {
            Parsers.Success success2 = (Parsers.Success)parseResult;
            Object t = success2.result();
            scala.util.parsing.input.Reader<Object> reader = success2.in();
            Object r = t;
            scala.util.parsing.input.Reader<Object> in = reader;
            if (BoxesRunTime.equals(r, result)) {
                if (in.atEnd()) {
                    return;
                }
                throw this.fail(new StringBuilder().append((Object)"input remaining at ").append((Object)in.pos()).toString());
            }
            throw this.fail(new StringBuilder().append((Object)"found ").append(r).append((Object)" not ").append(result).toString());
        }
        if (parseResult instanceof Parsers.Failure) {
            Parsers.Failure failure2 = (Parsers.Failure)parseResult;
            throw this.fail(new StringBuilder().append((Object)failure2.msg()).append((Object)" at ").append((Object)failure2.in().pos()).toString());
        }
        throw new MatchError(parseResult);
    }

    public <T> boolean isFailAt(Parsers.ParseResult<T> r, scala.util.parsing.input.Reader<Character> in) {
        Parsers.ParseResult<T> parseResult = r;
        return parseResult instanceof Parsers.Failure ? this.same(in, ((Parsers.Failure)parseResult).in()) : false;
    }

    public <T> boolean isSuccessWith(Parsers.ParseResult<T> r, T t) {
        Parsers.ParseResult<T> parseResult = r;
        return parseResult instanceof Parsers.Success && BoxesRunTime.equals(t, ((Parsers.Success)parseResult).result());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean isFailWith(Parsers.ParseResult<T> r, String m) {
        Parsers.ParseResult<T> parseResult = r;
        if (!(parseResult instanceof Parsers.Failure)) return false;
        String string2 = m;
        String string3 = ((Parsers.Failure)parseResult).msg();
        if (string2 != null) {
            if (!string2.equals(string3)) return false;
            return true;
        }
        if (string3 == null) return true;
        return false;
    }

    public <T> boolean isFail(Parsers.ParseResult<T> r) {
        Parsers.ParseResult<T> parseResult = r;
        return parseResult instanceof Parsers.Failure;
    }

    public <T> boolean same(Parsers.ParseResult<T> l, Parsers.ParseResult<T> r) {
        Parsers.ParseResult<T> parseResult;
        block9: {
            boolean bl;
            block8: {
                block7: {
                    parseResult = l;
                    if (!(parseResult instanceof Parsers.Success)) break block7;
                    Parsers.Success success2 = (Parsers.Success)parseResult;
                    Parsers.ParseResult<T> parseResult2 = r;
                    if (parseResult2 instanceof Parsers.Success) {
                        Parsers.Success success3 = (Parsers.Success)parseResult2;
                        bl = BoxesRunTime.equals(success2.result(), success3.result()) && this.same(success2.in(), success3.in());
                    } else {
                        bl = false;
                    }
                    break block8;
                }
                if (!(parseResult instanceof Parsers.Failure)) break block9;
                Parsers.Failure failure2 = (Parsers.Failure)parseResult;
                Parsers.ParseResult<T> parseResult3 = r;
                if (parseResult3 instanceof Parsers.Failure) {
                    Parsers.Failure failure3 = (Parsers.Failure)parseResult3;
                    String string2 = failure2.msg();
                    String string3 = failure3.msg();
                    bl = !(string2 != null ? !string2.equals(string3) : string3 != null) && this.same(failure2.in(), failure3.in());
                } else {
                    bl = false;
                }
            }
            return bl;
        }
        throw new MatchError(parseResult);
    }

    public boolean same(scala.util.parsing.input.Reader<Character> l, scala.util.parsing.input.Reader<Character> r) {
        scala.util.parsing.input.Reader lv = l;
        scala.util.parsing.input.Reader rv = r;
        while (!lv.atEnd()) {
            if (rv.atEnd() || BoxesRunTime.unboxToChar((Object)lv.first()) != BoxesRunTime.unboxToChar((Object)rv.first())) {
                return false;
            }
            lv = lv.rest();
            rv = rv.rest();
        }
        return rv.atEnd();
    }

    public Random random() {
        return this.random;
    }

    public <T extends AST.PrettyPrintable> String arbASTToString(T t) {
        return this.pretty(t);
    }

    public <T extends AST.PrettyPrintable> scala.util.parsing.input.Reader<Character> arbASTToInput(T t) {
        return this.input(this.pretty(t));
    }

    public Arbitrary<scala.util.parsing.input.Reader<Character>> arbInput() {
        return Arbitrary$.MODULE$.apply((Function0)new $anonfun$arbInput$1(this));
    }

    public CharSequenceReader empty() {
        return this.empty;
    }

    public CharSequenceReader input(String str) {
        return new CharSequenceReader((CharSequence)str);
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public Nothing$ fail(Throwable x$1) {
        return Assertions.class.fail((Assertions)this, (Throwable)x$1);
    }

    public Nothing$ fail(String x$1, Throwable x$2) {
        return Assertions.class.fail((Assertions)this, (String)x$1, (Throwable)x$2);
    }

    public Nothing$ fail(String x$1) {
        return Assertions.class.fail((Assertions)this, (String)x$1);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public void expect(Object x$1, Object x$2) {
        Assertions.class.expect((Assertions)this, (Object)x$1, (Object)x$2);
    }

    public void expect(Object x$1, Object x$2, Object x$3) {
        Assertions.class.expect((Assertions)this, (Object)x$1, (Object)x$2, (Object)x$3);
    }

    public Object intercept(Function0 x$1, Manifest x$2) {
        return Assertions.class.intercept((Assertions)this, (Function0)x$1, (Manifest)x$2);
    }

    public Object intercept(Class x$1, Function0 x$2) {
        return Assertions.class.intercept((Assertions)this, (Class)x$1, (Function0)x$2);
    }

    public Object intercept(Class x$1, Object x$2, Function0 x$3) {
        return Assertions.class.intercept((Assertions)this, (Class)x$1, (Object)x$2, (Function0)x$3);
    }

    public Assertions.Equalizer convertToEqualizer(Object x$1) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)x$1);
    }

    public void assert(Option x$1) {
        Assertions.class.assert((Assertions)this, (Option)x$1);
    }

    public void assert(Option x$1, Object x$2) {
        Assertions.class.assert((Assertions)this, (Option)x$1, (Object)x$2);
    }

    public void assert(boolean x$1, Object x$2) {
        Assertions.class.assert((Assertions)this, (boolean)x$1, (Object)x$2);
    }

    public void assert(boolean x$1) {
        Assertions.class.assert((Assertions)this, (boolean)x$1);
    }

    public Reporter wrapReporterIfNecessary(Reporter x$1) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)x$1);
    }

    public int expectedTestCount(Set x$1, Set x$2) {
        return Suite.class.expectedTestCount((Suite)this, (Set)x$1, (Set)x$2);
    }

    public String getTestNameForReport(String x$1) {
        return Suite.class.getTestNameForReport((Suite)this, (String)x$1);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public void runNestedSuites(Reporter x$1, Stopper x$2, Set x$3, Set x$4, Map x$5, Option x$6) {
        Suite.class.runNestedSuites((Suite)this, (Reporter)x$1, (Stopper)x$2, (Set)x$3, (Set)x$4, (Map)x$5, (Option)x$6);
    }

    public void runTests(Option x$1, Reporter x$2, Stopper x$3, Set x$4, Set x$5, Map x$6) {
        Suite.class.runTests((Suite)this, (Option)x$1, (Reporter)x$2, (Stopper)x$3, (Set)x$4, (Set)x$5, (Map)x$6);
    }

    public void runTest(String x$1, Reporter x$2, Stopper x$3, Map x$4) {
        Suite.class.runTest((Suite)this, (String)x$1, (Reporter)x$2, (Stopper)x$3, (Map)x$4);
    }

    public Set testNames() {
        return Suite.class.testNames((Suite)this);
    }

    public Map groups() {
        return Suite.class.groups((Suite)this);
    }

    public final void execute(String x$1) {
        Suite.class.execute((Suite)this, (String)x$1);
    }

    public final void execute() {
        Suite.class.execute((Suite)this);
    }

    public List nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public void org$scalatest$Suite$$IgnoreAnnotation_$eq(String x$1) {
        this.org$scalatest$Suite$$IgnoreAnnotation = x$1;
    }

    public void org$scalatest$Suite$$InformerInParens_$eq(String x$1) {
        this.org$scalatest$Suite$$InformerInParens = x$1;
    }

    public void org$scalatest$Suite$$TestMethodPrefix_$eq(String x$1) {
        this.org$scalatest$Suite$$TestMethodPrefix = x$1;
    }

    public final String org$scalatest$Suite$$IgnoreAnnotation() {
        return this.org$scalatest$Suite$$IgnoreAnnotation;
    }

    public final String org$scalatest$Suite$$InformerInParens() {
        return this.org$scalatest$Suite$$InformerInParens;
    }

    public final String org$scalatest$Suite$$TestMethodPrefix() {
        return this.org$scalatest$Suite$$TestMethodPrefix;
    }

    public void runJUnit(Reporter x$1) {
        JUnit3Suite.class.runJUnit((JUnit3Suite)this, (Reporter)x$1);
    }

    public void execute(Option x$1, Reporter x$2, Stopper x$3, Set x$4, Set x$5, Map x$6, Option x$7) {
        JUnit3Suite.class.execute((JUnit3Suite)this, (Option)x$1, (Reporter)x$2, (Stopper)x$3, (Set)x$4, (Set)x$5, (Map)x$6, (Option)x$7);
    }

    public void check(Prop x$1) {
        Checkers.class.check((Checkers)this, (Prop)x$1);
    }

    public void check(Prop x$1, Test.Params x$2) {
        Checkers.class.check((Checkers)this, (Prop)x$1, (Test.Params)x$2);
    }

    public void check(Function6 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4, Arbitrary x$5, Shrink x$6, Arbitrary x$7, Shrink x$8, Arbitrary x$9, Shrink x$10, Arbitrary x$11, Shrink x$12, Arbitrary x$13, Shrink x$14) {
        Checkers.class.check((Checkers)this, (Function6)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4, (Arbitrary)x$5, (Shrink)x$6, (Arbitrary)x$7, (Shrink)x$8, (Arbitrary)x$9, (Shrink)x$10, (Arbitrary)x$11, (Shrink)x$12, (Arbitrary)x$13, (Shrink)x$14);
    }

    public void check(Function5 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4, Arbitrary x$5, Shrink x$6, Arbitrary x$7, Shrink x$8, Arbitrary x$9, Shrink x$10, Arbitrary x$11, Shrink x$12) {
        Checkers.class.check((Checkers)this, (Function5)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4, (Arbitrary)x$5, (Shrink)x$6, (Arbitrary)x$7, (Shrink)x$8, (Arbitrary)x$9, (Shrink)x$10, (Arbitrary)x$11, (Shrink)x$12);
    }

    public void check(Function4 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4, Arbitrary x$5, Shrink x$6, Arbitrary x$7, Shrink x$8, Arbitrary x$9, Shrink x$10) {
        Checkers.class.check((Checkers)this, (Function4)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4, (Arbitrary)x$5, (Shrink)x$6, (Arbitrary)x$7, (Shrink)x$8, (Arbitrary)x$9, (Shrink)x$10);
    }

    public void check(Function3 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4, Arbitrary x$5, Shrink x$6, Arbitrary x$7, Shrink x$8) {
        Checkers.class.check((Checkers)this, (Function3)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4, (Arbitrary)x$5, (Shrink)x$6, (Arbitrary)x$7, (Shrink)x$8);
    }

    public void check(Function2 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4, Arbitrary x$5, Shrink x$6) {
        Checkers.class.check((Checkers)this, (Function2)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4, (Arbitrary)x$5, (Shrink)x$6);
    }

    public void check(Function1 x$1, Function1 x$2, Arbitrary x$3, Shrink x$4) {
        Checkers.class.check((Checkers)this, (Function1)x$1, (Function1)x$2, (Arbitrary)x$3, (Shrink)x$4);
    }

    public Parsers.Parser not(Function0 x$1) {
        return Parsers$class.not(this, x$1);
    }

    public Parsers.Parser and(Function0 x$1) {
        return Parsers$class.and(this, x$1);
    }

    public Parsers.Parser rep1sep(Function0 x$1, Function0 x$2) {
        return Parsers$class.rep1sep(this, x$1, x$2);
    }

    public Parsers.Parser repsep(Function0 x$1, Function0 x$2) {
        return Parsers$class.repsep(this, x$1, x$2);
    }

    public Parsers.Parser repN(int x$1, Function0 x$2) {
        return Parsers$class.repN(this, x$1, x$2);
    }

    public Parsers.Parser rep1(Function0 x$1) {
        return Parsers$class.rep1(this, x$1);
    }

    public Parsers.Parser rep(Function0 x$1) {
        return Parsers$class.rep(this, x$1);
    }

    public Parsers.Parser opt(Function0 x$1) {
        return Parsers$class.opt(this, x$1);
    }

    public Parsers.Parser acceptIf(Function1 x$1) {
        return Parsers$class.acceptIf(this, x$1);
    }

    public Parsers.Parser accept(Object x$1) {
        return Parsers$class.accept(this, x$1);
    }

    public Parsers.Parser failure(String x$1) {
        return Parsers$class.failure(this, x$1);
    }

    public Parsers.Parser success(Object x$1) {
        return Parsers$class.success(this, x$1);
    }

    public Parsers.Parser Parser(Function1 x$1) {
        return Parsers$class.Parser(this, x$1);
    }

    @Override
    public void any_$eq(Parsers.Parser x$1) {
        this.any = x$1;
    }

    public Parsers.Parser any() {
        return this.any;
    }

    @Override
    public final /* synthetic */ Parsers$$tilde$ $tilde() {
        if (this.$tilde$module == null) {
            this.$tilde$module = new Parsers$$tilde$(this);
        }
        return this.$tilde$module;
    }

    @Override
    public final /* synthetic */ Parsers$Failure$ Failure() {
        if (this.Failure$module == null) {
            this.Failure$module = new Parsers$Failure$(this);
        }
        return this.Failure$module;
    }

    @Override
    public final /* synthetic */ Parsers$Success$ Success() {
        if (this.Success$module == null) {
            this.Success$module = new Parsers$Success$(this);
        }
        return this.Success$module;
    }

    public PackratParsers.MemoParser memo(Function0 x$1) {
        return PackratParsers$class.memo(this, x$1);
    }

    public PackratParsers.MemoParser rep1(Function0 x$1) {
        return PackratParsers$class.rep1(this, x$1);
    }

    public void LRStack_$eq(PackratParsers.LR x$1) {
        this.LRStack = x$1;
    }

    public PackratParsers.LR LRStack() {
        return this.LRStack;
    }

    @Override
    public final /* synthetic */ PackratParsers$LR$ LR() {
        if (this.LR$module == null) {
            this.LR$module = new PackratParsers$LR$(this);
        }
        return this.LR$module;
    }

    @Override
    public final /* synthetic */ PackratParsers$Result$ Result() {
        if (this.Result$module == null) {
            this.Result$module = new PackratParsers$Result$(this);
        }
        return this.Result$module;
    }

    public void heads_$eq(HashMap x$1) {
        this.heads = x$1;
    }

    public HashMap heads() {
        return this.heads;
    }

    @Override
    public final /* synthetic */ PackratParsers$Head$ Head() {
        if (this.Head$module == null) {
            this.Head$module = new PackratParsers$Head$(this);
        }
        return this.Head$module;
    }

    public Parsers.ParseResult parseAll(Function0 x$1, CharSequence x$2) {
        return CharParsers$class.parseAll((CharParsers)this, x$1, x$2);
    }

    public Parsers.ParseResult parseAll(Function0 x$1, Reader x$2) {
        return CharParsers$class.parseAll((CharParsers)this, x$1, x$2);
    }

    public Parsers.ParseResult parseAll(Function0 x$1, scala.util.parsing.input.Reader x$2) {
        return CharParsers$class.parseAll((CharParsers)this, x$1, x$2);
    }

    public Parsers.ParseResult parse(Function0 x$1, Reader x$2) {
        return CharParsers$class.parse((CharParsers)this, x$1, x$2);
    }

    public Parsers.ParseResult parse(Function0 x$1, CharSequence x$2) {
        return CharParsers$class.parse((CharParsers)this, x$1, x$2);
    }

    public Parsers.ParseResult parse(Function0 x$1, scala.util.parsing.input.Reader x$2) {
        return CharParsers$class.parse((CharParsers)this, x$1, x$2);
    }

    public Parsers.Parser regex(Regex x$1) {
        return CharParsers$class.regex(this, x$1);
    }

    public Parsers.Parser literal(String x$1) {
        return CharParsers$class.literal(this, x$1);
    }

    public Parsers.Parser phrase(Function0 x$1) {
        return CharParsers$class.phrase(this, x$1);
    }

    public Parsers.Parser token(Parsers.Parser x$1) {
        return CharParsers$class.token(this, x$1);
    }

    @Override
    public final Parsers.Parser kiama$parsing$CharParsers$$super$phrase(Function0 x$1) {
        return Parsers$class.phrase(this, x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser letterOrDigit() {
        if ((this.bitmap$1 & 4) != 0) return this.letterOrDigit;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$1 & 4) == 0) {
                this.letterOrDigit = CharParsers$class.letterOrDigit(this);
                this.bitmap$1 |= 4;
            }
            return this.letterOrDigit;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser letter() {
        if ((this.bitmap$1 & 1) != 0) return this.letter;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$1 & 1) == 0) {
                this.letter = CharParsers$class.letter(this);
                this.bitmap$1 |= 1;
            }
            return this.letter;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser digit() {
        if ((this.bitmap$0 & 0x40000000) != 0) return this.digit;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x40000000) == 0) {
                this.digit = CharParsers$class.digit(this);
                this.bitmap$0 |= 0x40000000;
            }
            return this.digit;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser layout() {
        if ((this.bitmap$0 & 0x10000000) != 0) return this.layout;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.layout = CharParsers$class.layout(this);
                this.bitmap$0 |= 0x10000000;
            }
            return this.layout;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser whitespace() {
        if ((this.bitmap$0 & 0x4000000) != 0) return this.whitespace;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.whitespace = CharParsers$class.whitespace(this);
                this.bitmap$0 |= 0x4000000;
            }
            return this.whitespace;
        }
    }

    public Arbitrary arbStmt() {
        return Generator$class.arbStmt(this);
    }

    public Gen genStmt(int x$1) {
        return Generator$class.genStmt(this, x$1);
    }

    public Gen genInternalStmt(int x$1) {
        return Generator$class.genInternalStmt(this, x$1);
    }

    public Arbitrary arbWhile() {
        return Generator$class.arbWhile(this);
    }

    public Gen genWhile(int x$1) {
        return Generator$class.genWhile(this, x$1);
    }

    public Arbitrary arbAsgn() {
        return Generator$class.arbAsgn(this);
    }

    public Gen genAsgn(int x$1) {
        return Generator$class.genAsgn(this, x$1);
    }

    public Arbitrary arbSeqn() {
        return Generator$class.arbSeqn(this);
    }

    public Gen genSeqn(int x$1) {
        return Generator$class.genSeqn(this, x$1);
    }

    public Arbitrary arbExp() {
        return Generator$class.arbExp(this);
    }

    public Gen genExp(int x$1) {
        return Generator$class.genExp(this, x$1);
    }

    public Gen genInternalExp(int x$1) {
        return Generator$class.genInternalExp(this, x$1);
    }

    public Gen genDiv(int x$1) {
        return Generator$class.genDiv(this, x$1);
    }

    public Gen genMul(int x$1) {
        return Generator$class.genMul(this, x$1);
    }

    public Gen genSub(int x$1) {
        return Generator$class.genSub(this, x$1);
    }

    public Gen genAdd(int x$1) {
        return Generator$class.genAdd(this, x$1);
    }

    public Gen genNeg(int x$1) {
        return Generator$class.genNeg(this, x$1);
    }

    public Arbitrary arbNum() {
        return Generator$class.arbNum(this);
    }

    @Override
    public void genLeafStmt_$eq(Object x$1) {
        this.genLeafStmt = x$1;
    }

    @Override
    public void genLeafExp_$eq(Gen x$1) {
        this.genLeafExp = x$1;
    }

    @Override
    public void genVar_$eq(Gen x$1) {
        this.genVar = x$1;
    }

    @Override
    public void genIdn_$eq(Gen x$1) {
        this.genIdn = x$1;
    }

    @Override
    public void genNum_$eq(Gen x$1) {
        this.genNum = x$1;
    }

    @Override
    public void genDouble_$eq(Gen x$1) {
        this.genDouble = x$1;
    }

    @Override
    public void genInteger_$eq(Gen x$1) {
        this.genInteger = x$1;
    }

    @Override
    public Object genLeafStmt() {
        return this.genLeafStmt;
    }

    public Gen genLeafExp() {
        return this.genLeafExp;
    }

    public Gen genVar() {
        return this.genVar;
    }

    public Gen genIdn() {
        return this.genIdn;
    }

    public Gen genNum() {
        return this.genNum;
    }

    public Gen genDouble() {
        return this.genDouble;
    }

    public Gen genInteger() {
        return this.genInteger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser keyword() {
        if ((this.bitmap$0 & 0x1000000) != 0) return this.keyword;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.keyword = Parser$class.keyword(this);
                this.bitmap$0 |= 0x1000000;
            }
            return this.keyword;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser idn() {
        if ((this.bitmap$0 & 0x400000) != 0) return this.idn;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.idn = Parser$class.idn(this);
                this.bitmap$0 |= 0x400000;
            }
            return this.idn;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser variable() {
        if ((this.bitmap$0 & 0x100000) != 0) return this.variable;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.variable = Parser$class.variable(this);
                this.bitmap$0 |= 0x100000;
            }
            return this.variable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser integer() {
        if ((this.bitmap$0 & 0x40000) != 0) return this.integer;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.integer = Parser$class.integer(this);
                this.bitmap$0 |= 0x40000;
            }
            return this.integer;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser double() {
        if ((this.bitmap$0 & 0x10000) != 0) return this.double;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.double = Parser$class.double(this);
                this.bitmap$0 |= 0x10000;
            }
            return this.double;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackratParsers.MemoParser factor() {
        if ((this.bitmap$0 & 0x4000) != 0) return this.factor;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.factor = Parser$class.factor(this);
                this.bitmap$0 |= 0x4000;
            }
            return this.factor;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackratParsers.MemoParser term() {
        if ((this.bitmap$0 & 0x1000) != 0) return this.term;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.term = Parser$class.term(this);
                this.bitmap$0 |= 0x1000;
            }
            return this.term;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackratParsers.MemoParser exp() {
        if ((this.bitmap$0 & 0x400) != 0) return this.exp;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.exp = Parser$class.exp(this);
                this.bitmap$0 |= 0x400;
            }
            return this.exp;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser sequence() {
        if ((this.bitmap$0 & 0x100) != 0) return this.sequence;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.sequence = Parser$class.sequence(this);
                this.bitmap$0 |= 0x100;
            }
            return this.sequence;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser whileStmt() {
        if ((this.bitmap$0 & 0x40) != 0) return this.whileStmt;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.whileStmt = Parser$class.whileStmt(this);
                this.bitmap$0 |= 0x40;
            }
            return this.whileStmt;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser asgnStmt() {
        if ((this.bitmap$0 & 0x10) != 0) return this.asgnStmt;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.asgnStmt = Parser$class.asgnStmt(this);
                this.bitmap$0 |= 0x10;
            }
            return this.asgnStmt;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser stmt() {
        if ((this.bitmap$0 & 4) != 0) return this.stmt;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 4) == 0) {
                this.stmt = Parser$class.stmt(this);
                this.bitmap$0 |= 4;
            }
            return this.stmt;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parsers.Parser parse() {
        if ((this.bitmap$0 & 1) != 0) return this.parse;
        PackratParsersTests packratParsersTests = this;
        synchronized (packratParsersTests) {
            if ((this.bitmap$0 & 1) == 0) {
                this.parse = Parser$class.parse(this);
                this.bitmap$0 |= 1;
            }
            return this.parse;
        }
    }

    public String pretty(AST.PrettyPrintable x$1) {
        return PrettyPrinter$class.pretty(this, x$1);
    }
}

