/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.DownloadFailureException;
import com.googlecode.download.maven.plugin.internal.FileNameUtils;
import com.googlecode.download.maven.plugin.internal.HttpFileRequester;
import com.googlecode.download.maven.plugin.internal.LoggingProgressReport;
import com.googlecode.download.maven.plugin.internal.SSLProtocols;
import com.googlecode.download.maven.plugin.internal.SilentProgressReport;
import com.googlecode.download.maven.plugin.internal.cache.DownloadCache;
import com.googlecode.download.maven.plugin.internal.checksum.Checksums;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.http.Header;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.bzip2.BZip2UnArchiver;
import org.codehaus.plexus.archiver.gzip.GZipUnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.snappy.SnappyUnArchiver;
import org.codehaus.plexus.archiver.xz.XZUnArchiver;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferListener;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="wget", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=false, threadSafe=true)
public class WGetMojo
extends AbstractMojo {
    @Parameter(alias="url", property="download.url", required=true)
    private URI uri;
    @Parameter(property="download.overwrite")
    private boolean overwrite;
    @Parameter(property="download.outputFileName")
    private String outputFileName;
    @Parameter(property="download.outputDirectory", defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="download.verify.md5")
    private String md5;
    @Parameter(property="download.verify.sha1")
    private String sha1;
    @Parameter(property="download.verify.sha256")
    private String sha256;
    @Parameter(property="download.verify.sha512")
    private String sha512;
    @Parameter(property="download.unpack", defaultValue="false")
    private boolean unpack;
    @Parameter(property="download.unpackWhenChanged", defaultValue="false")
    private boolean unpackWhenChanged;
    @Parameter(property="download.auth.serverId")
    private String serverId;
    @Parameter(property="download.auth.username")
    private String username;
    @Parameter(property="download.auth.password")
    private String password;
    @Parameter(property="download.retries", defaultValue="2")
    private int retries;
    @Parameter(defaultValue="3000")
    private int readTimeOut;
    @Parameter(property="download.cache.skip", defaultValue="false")
    private boolean skipCache;
    @Parameter(property="download.cache.directory")
    private File cacheDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(property="download.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="alwaysVerifyChecksum", defaultValue="false")
    private boolean alwaysVerifyChecksum;
    @Deprecated
    @Parameter(property="checkSignature", defaultValue="false")
    private boolean checkSignature;
    @Parameter(property="download.plugin.followRedirects", defaultValue="true")
    private boolean followRedirects = true;
    @Parameter(property="download.plugin.headers")
    private Map<String, String> headers = new HashMap<String, String>();
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Inject
    private ArchiverManager archiverManager;
    @Inject
    private BuildContext buildContext;
    @Parameter(property="runOnlyAtRoot", defaultValue="false")
    private boolean runOnlyAtRoot;
    @Parameter(property="maxLockWaitTime", defaultValue="30000")
    private long maxLockWaitTime;
    @Parameter(property="download.fileMappers")
    private FileMapper[] fileMappers;
    @Parameter(property="preemptiveAuth", defaultValue="false")
    private boolean preemptiveAuth;
    @Parameter(property="download.unpack.includes")
    private String[] includes;
    @Parameter(property="download.unpack.excludes")
    private String[] excludes;
    private static final PoolingHttpClientConnectionManager CONN_POOL;
    private static final Map<String, DownloadCache> DOWNLOAD_CACHES;
    private static final Map<String, Lock> FILE_LOCKS;
    @Parameter(property="insecure", defaultValue="false")
    private boolean insecure;

    private void adjustOutputDirectory() throws MojoExecutionException {
        if (this.outputDirectory.getPath().contains("${")) {
            this.getLog().info((CharSequence)String.format("Could not resolve outputDirectory '%s'. Consider using -Ddownload.outputDirectory=.", this.outputDirectory.getPath()));
            this.outputDirectory = new File(".");
            try {
                this.getLog().info((CharSequence)("Adjusting outputDirectory to " + this.outputDirectory.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Current working directory could not be resolved. This should never happen.");
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Optional<Object> cache;
        if (this.skip) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped");
            return;
        }
        if (this.runOnlyAtRoot && !this.session.getCurrentProject().isExecutionRoot()) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped (not project root)");
            return;
        }
        if (org.codehaus.plexus.util.StringUtils.isNotBlank((String)this.serverId) && (org.codehaus.plexus.util.StringUtils.isNotBlank((String)this.username) || org.codehaus.plexus.util.StringUtils.isNotBlank((String)this.password))) {
            throw new MojoExecutionException("Specify either serverId or username/password, not both");
        }
        if (this.session.getSettings() == null) {
            this.getLog().warn((CharSequence)"settings is null");
        }
        if (this.session.getSettings().isOffline()) {
            this.getLog().debug((CharSequence)"maven-download-plugin:wget offline mode");
        }
        this.getLog().debug((CharSequence)"Got settings");
        if (this.retries < 1) {
            throw new MojoFailureException("retries must be at least 1");
        }
        if (!this.skipCache) {
            if (this.cacheDirectory == null) {
                this.cacheDirectory = new File(this.session.getLocalRepository().getBasedir(), ".cache/download-maven-plugin");
            } else if (this.cacheDirectory.exists() && !this.cacheDirectory.isDirectory()) {
                throw new MojoFailureException(String.format("cacheDirectory is not a directory: " + this.cacheDirectory.getAbsolutePath(), new Object[0]));
            }
            this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
            cache = Optional.of(DOWNLOAD_CACHES.computeIfAbsent(this.cacheDirectory.getAbsolutePath(), directory -> new DownloadCache(this.cacheDirectory, this.getLog())));
        } else {
            this.getLog().debug((CharSequence)"Cache is skipped");
            cache = Optional.empty();
        }
        this.adjustOutputDirectory();
        if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
            throw new MojoExecutionException("outputDirectory is not a directory: " + this.outputDirectory.getAbsolutePath());
        }
        this.outputDirectory.mkdirs();
        if (this.outputFileName == null) {
            this.outputFileName = FileNameUtils.getOutputFileName(this.uri);
        }
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        Lock fileLock = FILE_LOCKS.computeIfAbsent(outputFile.getAbsolutePath(), ignored -> new ReentrantLock());
        Checksums checksums = new Checksums(this.md5, this.sha1, this.sha256, this.sha512, this.getLog());
        boolean lockAcquired = false;
        try {
            lockAcquired = fileLock.tryLock(this.maxLockWaitTime, TimeUnit.MILLISECONDS);
            if (!lockAcquired) {
                String message = String.format("Could not acquire lock for File: %s in %dms", outputFile, this.maxLockWaitTime);
                if (this.failOnError) {
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)message);
                return;
            }
            boolean haveFile = outputFile.exists();
            if (haveFile) {
                boolean checksumMatch = true;
                if (this.alwaysVerifyChecksum || this.checkSignature) {
                    try {
                        checksums.validate(outputFile);
                    }
                    catch (MojoFailureException e) {
                        this.getLog().warn((CharSequence)("The local version of file " + outputFile.getName() + " doesn't match the expected checksum. You should consider checking the specified checksum is correctly set."));
                        checksumMatch = false;
                    }
                }
                if (!checksumMatch || this.overwrite) {
                    outputFile.delete();
                    haveFile = false;
                } else {
                    this.getLog().info((CharSequence)"File already exists, skipping");
                }
            }
            Optional<Object> cachedFile = Optional.empty();
            boolean fileWasCached = false;
            if (!haveFile) {
                cachedFile = cache.map(c -> c.getArtifact(this.uri, checksums));
                fileWasCached = cachedFile.map(File::exists).orElse(false);
                if (fileWasCached) {
                    this.getLog().debug((CharSequence)("File was cached: " + ((File)cachedFile.get()).getAbsolutePath()));
                    if (!this.unpack && !this.unpackWhenChanged) {
                        this.getLog().debug((CharSequence)("Copying cached file to " + outputFile.getAbsolutePath()));
                        Files.copy(((File)cachedFile.get()).toPath(), outputFile.toPath(), new CopyOption[0]);
                    }
                } else {
                    if (this.session.getRepositorySession().isOffline()) {
                        if (this.failOnError) {
                            throw new MojoExecutionException("No file in cache and maven is in offline mode");
                        }
                        this.getLog().warn((CharSequence)"Ignoring download failure.");
                    }
                    boolean done = false;
                    for (int retriesLeft = this.retries; !done && retriesLeft > 0; --retriesLeft) {
                        try {
                            this.doGet(outputFile);
                            checksums.validate(outputFile);
                            done = true;
                        }
                        catch (DownloadFailureException ex) {
                            if (this.failOnError && ex.getHttpCode() < 500) {
                                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                            }
                            this.getLog().warn((CharSequence)ex.getMessage());
                        }
                        catch (IOException ex) {
                            if (this.failOnError) {
                                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                            }
                            this.getLog().warn((CharSequence)ex.getMessage());
                        }
                        if (done) continue;
                        this.getLog().warn((CharSequence)("Retrying (" + (retriesLeft - 1) + " more)"));
                    }
                    if (!done) {
                        if (this.failOnError) {
                            throw new MojoFailureException("Could not get content after " + this.retries + " failed attempts.");
                        }
                        this.getLog().warn((CharSequence)"Ignoring download failure(s).");
                        return;
                    }
                }
            }
            if (cache.isPresent()) {
                ((DownloadCache)cache.get()).install(this.uri, outputFile, checksums);
            }
            if (this.unpack || this.unpackWhenChanged) {
                if (!this.unpack && this.unpackWhenChanged && fileWasCached) {
                    this.getLog().info((CharSequence)"Skipping unpacking as the file has not changed");
                } else {
                    if (this.unpackWhenChanged && fileWasCached) {
                        this.getLog().info((CharSequence)"Unpacking even though unchanged cache file exists because unpack = true");
                    }
                    this.unpack(outputFile, cachedFile);
                    this.buildContext.refresh(this.outputDirectory);
                }
            } else {
                this.buildContext.refresh(outputFile);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("IO Error: ", (Exception)ex);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No such archiver: " + e.getMessage());
        }
        catch (Exception e) {
            throw new MojoExecutionException("General error: ", e);
        }
        finally {
            if (lockAcquired) {
                fileLock.unlock();
            }
        }
    }

    private void unpack(File outputFile, Optional<File> cachedFile) throws NoSuchArchiverException {
        UnArchiver unarchiver = this.archiverManager.getUnArchiver(outputFile);
        if (cachedFile.isPresent() && cachedFile.get().exists()) {
            unarchiver.setSourceFile(cachedFile.get());
        } else if (outputFile.exists()) {
            unarchiver.setSourceFile(outputFile);
        } else {
            throw new IllegalStateException("No file to unpack");
        }
        if (this.isFileUnArchiver(unarchiver)) {
            unarchiver.setDestFile(new File(this.outputDirectory, this.outputFileName.substring(0, this.outputFileName.lastIndexOf(46))));
        } else {
            unarchiver.setDestDirectory(this.outputDirectory);
        }
        unarchiver.setFileMappers(this.fileMappers);
        this.addFileSelectorIfNeeded(unarchiver);
        unarchiver.extract();
        if (outputFile.exists()) {
            outputFile.delete();
        }
    }

    private boolean isFileUnArchiver(UnArchiver unarchiver) {
        return unarchiver instanceof BZip2UnArchiver || unarchiver instanceof GZipUnArchiver || unarchiver instanceof SnappyUnArchiver || unarchiver instanceof XZUnArchiver;
    }

    private static RemoteRepository createRemoteRepository(String serverId, URI uri) {
        return new RemoteRepository.Builder(StringUtils.isBlank((String)serverId) ? null : serverId, StringUtils.isBlank((String)serverId) ? uri.getScheme() : null, StringUtils.isBlank((String)serverId) ? uri.getScheme() + "://" + uri.getHost() : null).build();
    }

    private boolean showTransferProgress(MavenSession session) {
        if (!session.getSettings().isInteractiveMode()) {
            return false;
        }
        TransferListener transferListener = session.getRequest().getTransferListener();
        if (transferListener == null) {
            return true;
        }
        return !"QuietMavenTransferListener".equals(transferListener.getClass().getSimpleName());
    }

    private void doGet(File outputFile) throws IOException, MojoExecutionException {
        HttpFileRequester.Builder fileRequesterBuilder = new HttpFileRequester.Builder();
        RemoteRepository repository = WGetMojo.createRemoteRepository(this.serverId, this.uri);
        Optional.ofNullable(this.session.getRepositorySession().getProxySelector()).map(selector -> selector.getProxy(repository)).ifPresent(proxy -> this.addProxy(fileRequesterBuilder, repository, (Proxy)proxy));
        Optional.ofNullable(this.session.getRepositorySession().getAuthenticationSelector()).map(selector -> selector.getAuthentication(repository)).ifPresent(auth -> this.addAuthentication(fileRequesterBuilder, repository, (Authentication)auth));
        HttpFileRequester fileRequester = fileRequesterBuilder.withProgressReport(this.showTransferProgress(this.session) ? new LoggingProgressReport(this.getLog()) : new SilentProgressReport(this.getLog())).withConnectTimeout(this.readTimeOut).withSocketTimeout(this.readTimeOut).withUri(this.uri).withUsername(this.username).withPassword(this.password).withServerId(this.serverId).withPreemptiveAuth(this.preemptiveAuth).withMavenSession(this.session).withRedirectsEnabled(this.followRedirects).withLog(this.getLog()).withInsecure(this.insecure).build();
        fileRequester.download(outputFile, this.getAdditionalHeaders());
    }

    private void addProxy(HttpFileRequester.Builder fileRequesterBuilder, RemoteRepository repository, Proxy proxy) {
        fileRequesterBuilder.withProxyHost(proxy.getHost());
        fileRequesterBuilder.withProxyPort(proxy.getPort());
        RemoteRepository proxyRepo = new RemoteRepository.Builder(repository).setProxy(proxy).build();
        try (AuthenticationContext ctx = AuthenticationContext.forProxy((RepositorySystemSession)this.session.getRepositorySession(), (RemoteRepository)proxyRepo);){
            if (ctx != null) {
                fileRequesterBuilder.withProxyUserName(ctx.get("username"));
                fileRequesterBuilder.withProxyPassword(ctx.get("password"));
                fileRequesterBuilder.withNtlmDomain(ctx.get("ntlm.domain"));
                fileRequesterBuilder.withNtlmHost(ctx.get("ntlm.workstation"));
            }
        }
    }

    private void addAuthentication(HttpFileRequester.Builder fileRequesterBuilder, RemoteRepository repository, Authentication authentication) {
        RemoteRepository authRepo = new RemoteRepository.Builder(repository).setAuthentication(authentication).build();
        try (AuthenticationContext authCtx = AuthenticationContext.forRepository((RepositorySystemSession)this.session.getRepositorySession(), (RemoteRepository)authRepo);){
            String username = authCtx.get("username");
            String password = authCtx.get("password");
            String ntlmDomain = authCtx.get("ntlm.domain");
            String ntlmHost = authCtx.get("ntlm.workstation");
            this.getLog().debug((CharSequence)"providing custom authentication");
            this.getLog().debug((CharSequence)("username: " + username + " and password: ***"));
            fileRequesterBuilder.withUsername(username);
            fileRequesterBuilder.withPassword(password);
            fileRequesterBuilder.withNtlmDomain(ntlmDomain);
            fileRequesterBuilder.withNtlmHost(ntlmHost);
        }
    }

    private List<Header> getAdditionalHeaders() {
        return this.headers.entrySet().stream().map(pair -> new BasicHeader((String)pair.getKey(), (String)pair.getValue())).collect(Collectors.toList());
    }

    private void addFileSelectorIfNeeded(UnArchiver unarchiver) {
        if (this.includes.length != 0 || this.excludes.length != 0) {
            IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
            if (this.includes.length != 0) {
                fileSelector.setIncludes(this.includes);
            }
            if (this.excludes.length != 0) {
                fileSelector.setExcludes(this.excludes);
            }
            unarchiver.setFileSelectors(new FileSelector[]{fileSelector});
        }
    }

    static {
        DOWNLOAD_CACHES = new ConcurrentHashMap<String, DownloadCache>();
        FILE_LOCKS = new ConcurrentHashMap<String, Lock>();
        CONN_POOL = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), SSLProtocols.supported(), null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build(), null, null, null, 1L, TimeUnit.MINUTES);
    }
}

