/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.CachedFileEntry;
import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class DownloadCache {
    private static final String INDEX_FILENAME = "index.ser";
    private File basedir;
    private File indexFile;
    private Map<String, CachedFileEntry> index;

    public DownloadCache(File cacheDirectory) throws MojoExecutionException {
        this.basedir = cacheDirectory;
        this.indexFile = new File(this.basedir, INDEX_FILENAME);
        if (this.basedir.exists() && !this.basedir.isDirectory()) {
            throw new MojoExecutionException("Cannot use " + this.basedir + " as cache directory: file exists");
        }
        if (!this.basedir.exists()) {
            this.basedir.mkdirs();
        }
    }

    private CachedFileEntry getEntry(String url, String md5, String sha1, String sha512) throws Exception {
        this.loadIndex();
        CachedFileEntry res = this.index.get(url);
        if (res == null) {
            return null;
        }
        File resFile = new File(this.basedir, res.fileName);
        if (!resFile.isFile()) {
            return null;
        }
        if (md5 != null && !md5.equals(SignatureUtils.getMD5(resFile))) {
            return null;
        }
        if (sha1 != null && !sha1.equals(SignatureUtils.getSHA1(resFile))) {
            return null;
        }
        if (sha512 != null && !sha512.equals(SignatureUtils.getSHA512(resFile))) {
            return null;
        }
        return res;
    }

    public File getArtifact(String url, String md5, String sha1, String sha512) throws Exception {
        CachedFileEntry res = this.getEntry(url, md5, sha1, sha512);
        if (res != null) {
            return new File(this.basedir, res.fileName);
        }
        return null;
    }

    public void install(String url, File outputFile, String md5, String sha1, String sha512) throws Exception {
        CachedFileEntry entry;
        if (md5 == null) {
            md5 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("MD5"));
        }
        if (sha1 == null) {
            sha1 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("SHA1"));
        }
        if (sha512 == null) {
            sha512 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("SHA-512"));
        }
        if ((entry = this.getEntry(url, md5, sha1, sha512)) != null) {
            return;
        }
        entry = new CachedFileEntry();
        entry.fileName = outputFile.getName() + '_' + DigestUtils.md5Hex((String)url);
        Files.copy(outputFile.toPath(), new File(this.basedir, entry.fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.loadIndex();
        this.index.put(url, entry);
        this.saveIndex();
    }

    private void loadIndex() throws Exception {
        block25: {
            if (this.indexFile.isFile()) {
                try (FileLock lock = new RandomAccessFile(this.indexFile, "r").getChannel().lock(0L, Long.MAX_VALUE, true);
                     ObjectInputStream deserialize = new ObjectInputStream(new FileInputStream(this.indexFile));){
                    this.index = (Map)deserialize.readObject();
                    break block25;
                }
            }
            this.index = new HashMap<String, CachedFileEntry>();
        }
    }

    private void saveIndex() throws Exception {
        if (!this.indexFile.exists()) {
            this.indexFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(this.indexFile);
        try (ObjectOutputStream res = new ObjectOutputStream(out);
             FileLock lock = out.getChannel().lock();){
            res.writeObject(this.index);
        }
    }
}

