/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.plugin.MojoFailureException;

public class SignatureUtils {
    static void verifySignature(File file, String expectedDigest, MessageDigest digest) throws Exception {
        String actualDigestHex = SignatureUtils.computeSignatureAsString(file, digest);
        if (!actualDigestHex.equals(expectedDigest)) {
            throw new MojoFailureException("Not same digest as expected: expected <" + expectedDigest + "> was <" + actualDigestHex + ">");
        }
    }

    static String computeSignatureAsString(File file, MessageDigest digest) throws IOException {
        int numRead;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            digest.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        byte[] actualDigest = digest.digest();
        return new String(Hex.encodeHex((byte[])actualDigest));
    }

    static String getMD5(File file) throws IOException, NoSuchAlgorithmException {
        return SignatureUtils.computeSignatureAsString(file, MessageDigest.getInstance("MD5"));
    }

    static String getSHA1(File file) throws IOException, NoSuchAlgorithmException {
        return SignatureUtils.computeSignatureAsString(file, MessageDigest.getInstance("SHA1"));
    }

    static String getSHA512(File file) throws IOException, NoSuchAlgorithmException {
        return SignatureUtils.computeSignatureAsString(file, MessageDigest.getInstance("SHA-512"));
    }
}

