/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

final class ConsoleDownloadMonitor
implements TransferListener {
    private static final String PROGRESS_FORMAT = "%d/%s";
    private static final long KBYTE = 1024L;
    private final Log log;
    private long completed;

    ConsoleDownloadMonitor(Log logger) {
        this.log = logger;
        this.completed = 0L;
    }

    public void transferInitiated(TransferEvent event) {
        this.completed = 0L;
        this.log.info((CharSequence)String.format("%s: %s/%s", event.getRequestType() == 6 ? "Uploading" : "Downloading", event.getWagon().getRepository().getUrl(), event.getResource().getName()));
    }

    public void transferStarted(TransferEvent event) {
    }

    public void transferProgress(TransferEvent event, byte[] buffer, int length) {
        long completedInUnits;
        String totalInUnits;
        long total = event.getResource().getContentLength();
        this.completed += (long)length;
        if (total >= 1024L) {
            totalInUnits = total == -1L ? "?" : total / 1024L + "K";
            completedInUnits = this.completed / 1024L;
        } else {
            totalInUnits = total == -1L ? "?" : total + "b";
            completedInUnits = this.completed;
        }
        this.log.info((CharSequence)String.format(PROGRESS_FORMAT, completedInUnits, totalInUnits));
    }

    public void transferCompleted(TransferEvent event) {
        long length = event.getResource().getContentLength();
        if (length != -1L) {
            this.log.info((CharSequence)String.format("%s %s", event.getRequestType() == 6 ? "uploaded" : "downloaded", length >= 1024L ? length / 1024L + "K" : length + "b"));
        }
    }

    public void transferError(TransferEvent event) {
        this.log.error((Throwable)event.getException());
    }

    public void debug(String message) {
        this.log.debug((CharSequence)message);
    }
}

