/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import com.googlecode.download.maven.plugin.internal.cache.IncompatibleIndexException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FileBackedIndex
implements FileIndex {
    private final Map<URI, String> index = new HashMap<URI, String>();
    private final File storage;
    private final ReentrantLock lock = new ReentrantLock();

    FileBackedIndex(File baseDir) {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot use %s as cache directory: not exist or not a directory", baseDir.getAbsolutePath()));
        }
        File store = new File(baseDir, "index.ser");
        if (store.exists()) {
            try {
                this.loadFrom(store);
            }
            catch (IncompatibleIndexException e) {
                FileBackedIndex.deleteIncompatible(store);
                FileBackedIndex.create(store);
            }
        } else {
            FileBackedIndex.create(store);
        }
        this.storage = store;
    }

    @Override
    public void put(URI uri, String path) {
        this.index.put(uri, path);
        this.save();
    }

    @Override
    public String get(URI uri) {
        this.loadFrom(this.storage);
        return this.index.get(uri);
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    private static void create(File store) {
        try {
            if (!store.createNewFile()) {
                throw new IllegalStateException(String.format("Failed to create index storage file %s", store.getAbsolutePath()));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void deleteIncompatible(File store) {
        if (!store.delete()) {
            throw new IllegalStateException(String.format("Failed to delete incompatible index storage file %s", store.getAbsolutePath()));
        }
    }

    private void loadFrom(File store) throws IncompatibleIndexException {
        if (store.length() != 0L) {
            try (RandomAccessFile file = new RandomAccessFile(store, "r");
                 FileChannel channel = file.getChannel();
                 FileLock lock = channel.lock(0L, Long.MAX_VALUE, true);
                 ObjectInputStream deserialize = new ObjectInputStream(new FileInputStream(store));){
                this.index.clear();
                this.index.putAll((Map)deserialize.readObject());
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                throw new IncompatibleIndexException(e);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void save() {
        try (FileOutputStream file = new FileOutputStream(this.storage);
             ObjectOutputStream res = new ObjectOutputStream(file);
             FileChannel channel = file.getChannel();
             FileLock lock = channel.lock();){
            res.writeObject(this.index);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

