/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.signature;

import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import com.googlecode.download.maven.plugin.internal.signature.Signature;
import java.io.File;
import java.security.MessageDigest;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public final class Signatures {
    private final Map<Signature, String> supplied;

    public Signatures(@Nullable String md5, @Nullable String sha1, @Nullable String sha256, @Nullable String sha512, Log log) {
        this.supplied = Signatures.create(md5, sha1, sha256, sha512);
        if (this.supplied.isEmpty()) {
            log.debug((CharSequence)"No signatures were supplied, skipping file validation");
        } else if (this.supplied.size() > 1) {
            log.warn((CharSequence)"More than one signature is supplied. This may be slow for big files. Consider using a single signature");
        }
    }

    public boolean isValid(File file) {
        boolean valid = true;
        try {
            this.validate(file);
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    public void validate(File file) throws Exception {
        for (Map.Entry<Signature, String> entry : this.supplied.entrySet()) {
            SignatureUtils.verifySignature(file, entry.getValue(), MessageDigest.getInstance(entry.getKey().algo()));
        }
    }

    private static Map<Signature, String> create(@Nullable String md5, @Nullable String sha1, @Nullable String sha256, @Nullable String sha512) {
        EnumMap<Signature, String> digests = new EnumMap<Signature, String>(Signature.class);
        if (md5 != null) {
            digests.put(Signature.MD5, md5);
        }
        if (sha1 != null) {
            digests.put(Signature.SHA1, sha1);
        }
        if (sha256 != null) {
            digests.put(Signature.SHA256, sha256);
        }
        if (sha512 != null) {
            digests.put(Signature.SHA512, sha512);
        }
        return digests;
    }
}

