/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.HttpFileRequester;
import com.googlecode.download.maven.plugin.internal.LoggingProgressReport;
import com.googlecode.download.maven.plugin.internal.SSLProtocols;
import com.googlecode.download.maven.plugin.internal.SilentProgressReport;
import com.googlecode.download.maven.plugin.internal.cache.DownloadCache;
import com.googlecode.download.maven.plugin.internal.checksum.Checksums;
import java.io.File;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.bzip2.BZip2UnArchiver;
import org.codehaus.plexus.archiver.gzip.GZipUnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.snappy.SnappyUnArchiver;
import org.codehaus.plexus.archiver.xz.XZUnArchiver;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="wget", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true, threadSafe=true)
public class WGet
extends AbstractMojo {
    private static final PoolingHttpClientConnectionManager CONN_POOL;
    private static final Map<String, DownloadCache> DOWNLOAD_CACHES;
    private static final Map<String, Lock> FILE_LOCKS;
    @Parameter(alias="url", property="download.url", required=true)
    private URI uri;
    @Parameter(property="download.overwrite")
    private boolean overwrite;
    @Parameter(property="download.outputFileName")
    private String outputFileName;
    @Parameter(property="download.outputDirectory", defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="download.verify.md5")
    private String md5;
    @Parameter(property="download.verify.sha1")
    private String sha1;
    @Parameter(property="download.verify.sha256")
    private String sha256;
    @Parameter(property="download.verify.sha512")
    private String sha512;
    @Parameter(property="download.unpack", defaultValue="false")
    private boolean unpack;
    @Parameter(property="download.auth.serverId")
    private String serverId;
    @Parameter(property="download.auth.username")
    private String username;
    @Parameter(property="download.auth.password")
    private String password;
    @Parameter(defaultValue="2")
    private int retries;
    @Parameter(defaultValue="0")
    private int readTimeOut;
    @Parameter(property="download.cache.skip", defaultValue="false")
    private boolean skipCache;
    @Parameter(property="download.cache.directory")
    private File cacheDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(property="download.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="alwaysVerifyChecksum", defaultValue="false")
    private boolean alwaysVerifyChecksum;
    @Deprecated
    @Parameter(property="checkSignature", defaultValue="false")
    private boolean checkSignature;
    @Parameter(property="download.plugin.followRedirects", defaultValue="false")
    private boolean followRedirects;
    @Parameter(property="download.plugin.headers")
    private Map<String, String> headers = new HashMap<String, String>();
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private WagonManager wagonManager;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Parameter(property="runOnlyAtRoot", defaultValue="false")
    private boolean runOnlyAtRoot;
    @Parameter(property="maxLockWaitTime", defaultValue="30000")
    private long maxLockWaitTime;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped");
            return;
        }
        if (this.runOnlyAtRoot && !this.project.isExecutionRoot()) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped (not project root)");
            return;
        }
        if (StringUtils.isNotBlank((String)this.serverId) && (StringUtils.isNotBlank((String)this.username) || StringUtils.isNotBlank((String)this.password))) {
            throw new MojoExecutionException("Specify either serverId or username/password, not both");
        }
        if (this.settings == null) {
            this.getLog().warn((CharSequence)"settings is null");
        }
        if (this.settings.isOffline()) {
            this.getLog().debug((CharSequence)"maven-download-plugin:wget offline mode");
        }
        this.getLog().debug((CharSequence)"Got settings");
        if (this.retries < 1) {
            throw new MojoFailureException("retries must be at least 1");
        }
        if (this.outputFileName == null) {
            try {
                this.outputFileName = new File(this.uri.toURL().getFile()).getName();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid URL", ex);
            }
        }
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(this.session.getLocalRepository().getBasedir(), ".cache/download-maven-plugin");
        }
        this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
        DownloadCache cache = DOWNLOAD_CACHES.computeIfAbsent(this.cacheDirectory.getAbsolutePath(), directory -> new DownloadCache(new File((String)directory)));
        this.outputDirectory.mkdirs();
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        Lock fileLock = FILE_LOCKS.computeIfAbsent(outputFile.getAbsolutePath(), ignored -> new ReentrantLock());
        Checksums checksums = new Checksums(this.md5, this.sha1, this.sha256, this.sha512, this.getLog());
        boolean lockAcquired = false;
        try {
            lockAcquired = fileLock.tryLock(this.maxLockWaitTime, TimeUnit.MILLISECONDS);
            if (!lockAcquired) {
                String message = String.format("Could not acquire lock for File: %s in %dms", outputFile, this.maxLockWaitTime);
                if (this.failOnError) {
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)message);
                return;
            }
            boolean haveFile = outputFile.exists();
            if (haveFile) {
                boolean checksumMatch = true;
                if (this.alwaysVerifyChecksum || this.checkSignature) {
                    try {
                        checksums.validate(outputFile);
                    }
                    catch (MojoFailureException e) {
                        this.getLog().warn((CharSequence)("The local version of file " + outputFile.getName() + " doesn't match the expected checksum. You should consider checking the specified checksum is correctly set."));
                        checksumMatch = false;
                    }
                }
                if (!checksumMatch || this.overwrite) {
                    outputFile.delete();
                    haveFile = false;
                } else {
                    this.getLog().info((CharSequence)"File already exist, skipping");
                }
            }
            if (!haveFile) {
                File cached = cache.getArtifact(this.uri, checksums);
                if (!this.skipCache && cached != null && cached.exists()) {
                    this.getLog().debug((CharSequence)("Got from cache: " + cached.getAbsolutePath()));
                    Files.copy(cached.toPath(), outputFile.toPath(), new CopyOption[0]);
                } else {
                    if (this.settings.isOffline()) {
                        if (this.failOnError) {
                            throw new MojoExecutionException("No file in cache and maven is in offline mode");
                        }
                        this.getLog().warn((CharSequence)"Ignoring download failure.");
                    }
                    boolean done = false;
                    while (!done && this.retries > 0) {
                        try {
                            this.doGet(outputFile);
                            checksums.validate(outputFile);
                            done = true;
                        }
                        catch (Exception ex) {
                            this.getLog().warn((CharSequence)"Could not get content", (Throwable)ex);
                            --this.retries;
                            if (this.retries <= 0) continue;
                            this.getLog().warn((CharSequence)("Retrying (" + this.retries + " more)"));
                        }
                    }
                    if (!done) {
                        if (this.failOnError) {
                            throw new MojoFailureException("Could not get content");
                        }
                        this.getLog().warn((CharSequence)"Ignoring download failure.");
                        return;
                    }
                }
            }
            cache.install(this.uri, outputFile, checksums);
            if (this.unpack) {
                this.unpack(outputFile);
                this.buildContext.refresh(this.outputDirectory);
            } else {
                this.buildContext.refresh(outputFile);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("IO Error", ex);
        }
        finally {
            if (lockAcquired) {
                fileLock.unlock();
            }
        }
    }

    private void unpack(File outputFile) throws NoSuchArchiverException {
        UnArchiver unarchiver = this.archiverManager.getUnArchiver(outputFile);
        unarchiver.setSourceFile(outputFile);
        if (this.isFileUnArchiver(unarchiver)) {
            unarchiver.setDestFile(new File(this.outputDirectory, this.outputFileName.substring(0, this.outputFileName.lastIndexOf(46))));
        } else {
            unarchiver.setDestDirectory(this.outputDirectory);
        }
        unarchiver.extract();
        outputFile.delete();
    }

    private boolean isFileUnArchiver(UnArchiver unarchiver) {
        return unarchiver instanceof BZip2UnArchiver || unarchiver instanceof GZipUnArchiver || unarchiver instanceof SnappyUnArchiver || unarchiver instanceof XZUnArchiver;
    }

    private void doGet(File outputFile) throws Exception {
        SystemDefaultRoutePlanner routePlanner;
        RequestConfig requestConfig;
        if (this.readTimeOut > 0) {
            this.getLog().info((CharSequence)String.format("Read Timeout is set to %d milliseconds (apprx %d minutes)", this.readTimeOut, Math.round((double)this.readTimeOut * 1.66667E-5)));
            requestConfig = RequestConfig.custom().setConnectTimeout(this.readTimeOut).setSocketTimeout(this.readTimeOut).setRedirectsEnabled(this.followRedirects).build();
        } else {
            requestConfig = RequestConfig.DEFAULT;
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (StringUtils.isNotBlank((String)this.username)) {
            this.getLog().debug((CharSequence)"providing custom authentication");
            this.getLog().debug((CharSequence)("username: " + this.username + " and password: ***"));
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        } else if (StringUtils.isNotBlank((String)this.serverId)) {
            this.getLog().debug((CharSequence)("providing custom authentication for " + this.serverId));
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("Server %s not found", this.serverId));
            }
            this.getLog().debug((CharSequence)String.format("serverId %s supplies username: %s and password: ***", this.serverId, server.getUsername()));
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(server.getUsername(), this.decrypt(server.getPassword(), this.serverId)));
        }
        ProxyInfo proxyInfo = this.wagonManager.getProxy(this.uri.getScheme());
        if (this.useHttpProxy(proxyInfo)) {
            routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxyInfo.getHost(), proxyInfo.getPort()));
            if (proxyInfo.getUserName() != null) {
                Object creds = proxyInfo.getNtlmHost() != null || proxyInfo.getNtlmDomain() != null ? new NTCredentials(proxyInfo.getUserName(), proxyInfo.getPassword(), proxyInfo.getNtlmHost(), proxyInfo.getNtlmDomain()) : new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword());
                AuthScope authScope = new AuthScope(proxyInfo.getHost(), proxyInfo.getPort());
                if (credentialsProvider == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                }
                credentialsProvider.setCredentials(authScope, (Credentials)creds);
            }
        } else {
            routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        }
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)CONN_POOL).setConnectionManagerShared(true).setRoutePlanner((HttpRoutePlanner)routePlanner).build();){
            HttpFileRequester fileRequester = new HttpFileRequester(httpClient, this.session.getSettings().isInteractiveMode() ? new LoggingProgressReport(this.getLog()) : new SilentProgressReport(this.getLog()));
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setRequestConfig(requestConfig);
            if (credentialsProvider != null) {
                clientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            fileRequester.download(this.uri, outputFile, (HttpContext)clientContext, this.getAdditionalHeaders());
        }
    }

    private List<Header> getAdditionalHeaders() {
        return this.headers.entrySet().stream().map(pair -> new BasicHeader((String)pair.getKey(), (String)pair.getValue())).collect(Collectors.toList());
    }

    private String decrypt(String str, String server) {
        try {
            return this.securityDispatcher.decrypt(str);
        }
        catch (SecDispatcherException e) {
            this.getLog().warn((CharSequence)String.format("Failed to decrypt password/passphrase for server %s, using auth token as is", server), (Throwable)e);
            return str;
        }
    }

    private boolean useHttpProxy(ProxyInfo proxyInfo) {
        boolean result;
        if (proxyInfo == null) {
            result = false;
        } else if (proxyInfo.getHost() == null) {
            result = false;
        } else if (proxyInfo.getNonProxyHosts() == null) {
            result = true;
            this.getLog().debug((CharSequence)String.format("%s is a proxy host", this.uri.getHost()));
        } else {
            result = !ProxyUtils.validateNonProxyHosts((ProxyInfo)proxyInfo, (String)this.uri.getHost());
            this.getLog().debug((CharSequence)String.format("%s is a non-proxy host", this.uri.getHost()));
        }
        return result;
    }

    static {
        DOWNLOAD_CACHES = new ConcurrentHashMap<String, DownloadCache>();
        FILE_LOCKS = new ConcurrentHashMap<String, Lock>();
        CONN_POOL = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), SSLProtocols.supported(), null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build(), null, null, null, 1L, TimeUnit.MINUTES);
    }
}

