/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.plugin.MojoFailureException;

public class ChecksumUtils {
    public static void verifyChecksum(File file, String expectedDigest, MessageDigest digest) throws Exception {
        String actualDigestHex = ChecksumUtils.computeChecksumAsString(file, digest);
        if (!actualDigestHex.equals(expectedDigest)) {
            throw new MojoFailureException("Not same digest as expected: expected <" + expectedDigest + "> was <" + actualDigestHex + ">");
        }
    }

    public static String computeChecksumAsString(File file, MessageDigest digest) throws IOException {
        int numRead;
        InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[1024];
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            digest.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        byte[] actualDigest = digest.digest();
        return new String(Hex.encodeHex((byte[])actualDigest));
    }

    public static String getMD5(File file) throws IOException, NoSuchAlgorithmException {
        return ChecksumUtils.computeChecksumAsString(file, MessageDigest.getInstance("MD5"));
    }

    public static String getSHA1(File file) throws IOException, NoSuchAlgorithmException {
        return ChecksumUtils.computeChecksumAsString(file, MessageDigest.getInstance("SHA1"));
    }

    public static String getSHA256(File file) throws IOException, NoSuchAlgorithmException {
        return ChecksumUtils.computeChecksumAsString(file, MessageDigest.getInstance("SHA-256"));
    }

    public static String getSHA512(File file) throws IOException, NoSuchAlgorithmException {
        return ChecksumUtils.computeChecksumAsString(file, MessageDigest.getInstance("SHA-512"));
    }
}

