/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileIndexResource;
import com.googlecode.download.maven.plugin.internal.cache.IncompatibleIndexException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.Args;
import org.apache.maven.plugin.logging.Log;

@ThreadSafe
public final class FileBackedIndex
implements HttpCacheStorage {
    private static final Pattern URI_REGEX = Pattern.compile("^(?:\\{.*})?([^/]+//?.*)$");
    private static final String CACHE_FILENAME = "index.ser";
    private static final StatusLine OK_STATUS_LINE = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
    private final Map<URI, String> index = new ConcurrentHashMap<URI, String>();
    private final Path cacheIndexFile;
    private final Log log;
    private final Path baseDir;

    private static HttpCacheEntry asHttpCacheEntry(Path path, Path cacheDir) {
        Date lastModifiedDate;
        try {
            lastModifiedDate = Date.from(Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS).toInstant());
        }
        catch (IOException e) {
            lastModifiedDate = Date.from(Instant.now());
        }
        return new HttpCacheEntry(lastModifiedDate, Date.from(Instant.now()), OK_STATUS_LINE, new Header[]{new BasicHeader("Date", DateUtils.formatDate((Date)lastModifiedDate)), new BasicHeader("max-age", String.valueOf(Integer.MAX_VALUE)), new BasicHeader("Expires", DateUtils.formatDate((Date)Date.from(Instant.now().plus(365L, ChronoUnit.DAYS))))}, (Resource)new FileIndexResource(path, cacheDir));
    }

    private static Path asPath(HttpCacheEntry entry) {
        return ((FileIndexResource)entry.getResource()).getPath();
    }

    public FileBackedIndex(Path baseDir, Log log) throws NotDirectoryException {
        this.log = log;
        this.baseDir = baseDir;
        this.cacheIndexFile = Paths.get(baseDir.toString(), CACHE_FILENAME);
    }

    protected static URI asUri(String key) {
        Matcher uriMatcher = URI_REGEX.matcher(key);
        if (uriMatcher.find()) {
            try {
                return FileBackedIndex.normalize(URI.create(uriMatcher.group(1)));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    private static URI normalize(URI requestUri) throws URISyntaxException {
        Args.notNull((Object)requestUri, (String)"URI");
        URIBuilder builder = new URIBuilder(requestUri);
        if (builder.getHost() != null) {
            if (builder.getScheme() == null) {
                builder.setScheme("http");
            }
            if (builder.getPort() > -1) {
                builder.setPort(-1);
            }
        }
        builder.setFragment(null);
        return builder.build();
    }

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        URI uri = FileBackedIndex.asUri(key);
        if (uri != null) {
            this.log.debug((CharSequence)("Putting \"" + uri + "\" into cache"));
            this.index.put(uri, FileBackedIndex.asPath(entry).toString());
            try {
                this.load(this.cacheIndexFile);
            }
            catch (IncompatibleIndexException e) {
                this.log.warn((CharSequence)"Could not load index cache index file, it will be rewritten.");
            }
            this.save();
        } else {
            this.log.warn((CharSequence)("Could not extract an URI from key: " + key));
        }
    }

    public HttpCacheEntry getEntry(String uriString) {
        try {
            this.load(this.cacheIndexFile);
        }
        catch (IncompatibleIndexException | IOException e) {
            this.log.warn((CharSequence)("Error while reading from cache " + this.cacheIndexFile));
        }
        URI uri = FileBackedIndex.asUri(uriString);
        if (!this.index.containsKey(uri)) {
            this.log.debug((CharSequence)("Current cache: " + this.index.keySet().stream().map(u -> "\"" + u + "\"").collect(Collectors.joining(", ")) + " does not contain \"" + uri + "\""));
            return null;
        }
        Path cachedFile = Paths.get(this.index.get(uri), new String[0]);
        if (!Files.exists(this.baseDir.resolve(cachedFile), new LinkOption[0])) {
            this.log.debug((CharSequence)("Cached version of " + uri + " is gone; deleting cache entry"));
            this.index.remove(uri);
            try {
                this.load(this.cacheIndexFile);
                this.save();
            }
            catch (IncompatibleIndexException e) {
                this.log.warn((CharSequence)"Could not load index cache index file, it will be rewritten.");
            }
            catch (IOException e) {
                this.log.warn((CharSequence)"Unable to update cache.");
            }
        }
        return FileBackedIndex.asHttpCacheEntry(cachedFile, this.baseDir);
    }

    private void load(Path store) throws IncompatibleIndexException, IOException {
        if (Files.exists(store, new LinkOption[0]) && Files.size(store) != 0L) {
            try (RandomAccessFile file = new RandomAccessFile(store.toFile(), "r");
                 FileChannel channel = file.getChannel();
                 FileLock ignored = channel.lock(0L, Long.MAX_VALUE, true);
                 ObjectInputStream deserialize = new ObjectInputStream(Files.newInputStream(store, new OpenOption[0]));){
                Map newEntries = (Map)deserialize.readObject();
                newEntries.forEach(this.index::putIfAbsent);
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                throw new IncompatibleIndexException(e);
            }
        }
    }

    private void save() {
        try (FileOutputStream file = new FileOutputStream(this.cacheIndexFile.toFile());
             ObjectOutputStream res = new ObjectOutputStream(file);
             FileChannel channel = file.getChannel();
             FileLock ignored = channel.lock();){
            res.writeObject(new HashMap<URI, String>(this.index));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void removeEntry(String key) {
        assert (false);
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) {
    }
}

