package com.googlecode.mavenfilesync;

import java.util.ArrayList;
import java.util.List;

/**
 * A mapping descriptor. @See http://andrei.gmxhome.de/filesync/usage.html for
 * further details. The class is immutable and have no parameter constructor,
 * however the values are assigned by the maven extralinguistic mechanism.
 * 
 * @author Marek Dec
 */
public class FileSyncMapping {

	/**
	 * The source folder of a mapping.
	 * 
	 * @parameter
	 * @required
	 */
	private final String sourceFolder;

	private final String destinationFolder;

	private final String variablesFile;

	private final List<String> inclPatternList;
	private final List<String> exclPatternList;

	/**
	 * The filesync settings format uses a comma as an empty value.
	 */
	static final String MAPPING_EMPTY_VALUE = ",";

	/**
	 * Initializes the mapping to default values, which will be overriden if
	 * given by the maven magic.
	 */
	public FileSyncMapping() {
		super();
		this.sourceFolder = "";

		this.destinationFolder = MAPPING_EMPTY_VALUE;

		this.inclPatternList = new ArrayList<String>();
		this.inclPatternList.add(MAPPING_EMPTY_VALUE);

		this.exclPatternList = new ArrayList<String>();
		this.exclPatternList.add(MAPPING_EMPTY_VALUE);

		this.variablesFile = MAPPING_EMPTY_VALUE;
	}

	public String getSourceFolder() {
		return sourceFolder;
	}

	public List<String> getInclPatternList() {
		return inclPatternList;
	}

	public String getDestinationFolder() {
		return destinationFolder;
	}

	public List<String> getExclPatternList() {
		return exclPatternList;
	}

	public String getVariablesFile() {
		return variablesFile;
	}
}
